# Veteran - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Veteran**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Veteran

* [Profile](#profile)
* [Extension](#extension)
* [Verification](#verification)

| |
| :--- |
| The US Veteran profile specifies an additional extension to the set already supported by the FHIR US Core profile it extends. This extension is a boolean flag used to specify/store the confirmation/verification status. true: the Patient record describes a Veteran or false: the Patient is either not a verified yet or under review if the flag is absent, then the veteran status is undetermined. |

### Profile

[USVeteran](StructureDefinition-usveteran-definitions.md)

### Extension

[USVeteranStatus](StructureDefinition-military-service-veteran-status.md)

### Verification

Using patient match [patientmatch](https://www.hl7.org/fhir/operation-patient-match.html) verify existence of extension [USVeteranStatus](StructureDefinition-military-service-veteran-status.md) to evaluate veteran status. A return missing extension completely is a result of undetermined.

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

