# Military History - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Military History**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Military History

* [Military Service Episode](#military-service-episode)
* [Deployment History Episode](#deployment-history-episode)
* [Military Occupation](#military-occupation) 
* [Profiles](#profiles)
* [Terminolgy](#terminolgy)
 

## Military Service Episode

This profile design describes how we use observations, components, and member resources to represent an historical continual Military Service within on branch of service.

As such a veteran's Military Service Episode may have zero or more military service deployment episodes.

As such a veteran's Military Service Episode may have zero or more military occupations.

Additionally, the veteran's Military Service Episode contains military discharge and separation reasons.

## Deployment History Episode

Deployment History Episode describes a completed deployment. This is not intended to describe active duty deployments. The veterans Deployment History Episode code can contain the mission, the country, the industry, and the supervisory level.

## Military Occupation

The profile reuses the [ODHPastOrPresentJob](http://hl7.org/fhir/us/odh/StructureDefinition-odh-PastOrPresentJob.html) profile to apply it specifically to military jobs/occupations. One or more military occupations may be referenced by a single Military Service History record. This profile uses a subset of data elements as seen below:

### Profiles

### Terminolgy

Supervisory Level [ODHSupervisoryLevelValueSet](https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=2.16.840.1.114222.4.11.7613)

Occupation [ODHOccupationValueSet](https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=2.16.840.1.114222.4.11.7186)

Industry [ODHIndustryValueSet](https://phinvads.cdc.gov/vads/ViewValueSet.action?oid=2.16.840.1.114222.4.11.7187)

Military Service Branch [MilitaryServiceBranchValueSet](ValueSet-military-service-branch-vs.md)

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

