# Examples - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Examples**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Examples

* [Military Service History Examples](#military-service-history-examples)
* [USVeteran](#usveteran)
* [Military Service Episode](#military-service-episode)
* [Deployment History Episode](#deployment-history-episode)
* [Military Occupation](#military-occupation)

### Military Service History Examples

This section provides three examples of the profiles in the IG. The first is a Vietnam Veteran with 1 Deployment. The Second is a Desert Storm Veteran with 1 deployment, and the third is a Iraq War Veteran with 2 deployments.

Philip Scott Vietnam Veteran Example 71-72 US Marine Core 1 period, 1 deployment 68 years MALE (White) Name 1/22/1954

* ODH#55-1014.00.016076 "Field Artillery Officer [Artillery and Missile Officers]"

Hugo Cross MALE (Hispanic) Army Desert Storm Veteran Example August 2, 1990 – February 28, 1991 1 period, 1 deployments 50 years 2/12/1972

* ODH#55-3019.00.001795 "Army Ranger [Military Enlisted Tactical Operations and Air/Weapons Specialists and Crew Members, All Other]"

Crystal Huffman FEMALE (Black) Air Force Iraq War Veteran 1 period, 2 deployments 2014-2015 2016-2017 Age 30 2/20/1992

* ODH#55-1011.00.028062 "Naval Flight Officer, Airborne Reconnaissance Officer [Air Crew Officers]"
* ODH#55-1011.00.028067 "Naval Flight Officer, Weapons Systems Officer [Air Crew Officers]"

### USVeteran

* [`Phillip Scott US Veteran's patient record`](Patient-philip-scott-example-veteran.md)
* [`Hugo Cross US Veteran's patient record`](Patient-hugo-cross-example-veteran.md)
* [`Crystal Huffman US Veteran's patient record`](Patient-huffman-crystal-example-veteran.md)

### Military Service Episode

* [`Phillip Scott Military Service Episode`](Observation-philip-scott-example-military-service-episode.md)

### Deployment History Episode

* [`Phillip Scott Deployment History Episode`](Observation-philip-scott-example-deployment-history-episode.md)

### Military Occupation

* [`Phillip Scott Military Occupation`](Observation-philip-scott-example-military-occupation.md)

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

