# Downloads - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Downloads**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Downloads

### Download Links

* [Full Specification (zip)](full-ig.zip)
* [Package (tgz)](package.tgz)
* [JSON Definitions (zip)](definitions.json.zip)
* [JSON Examples (zip)](examples.json.zip)
* [XML Definitions (zip)](definitions.xml.zip)
* [XML Examples (zip)](examples.ttl.zip)
* [Turtle Definitions](definitions.ttl.zip)







#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* Copyright HL7. Licensed under creative commons public domain

* [identifierType](http://terminology.hl7.org/5.1.0/CodeSystem-v2-0203.html): [Patient/huffman-crystal-example-veteran](Patient-huffman-crystal-example-veteran.md), [Patient/hugo-cross-example-veteran](Patient-hugo-cross-example-veteran.md) and [Patient/philip-scott-example-veteran](Patient-philip-scott-example-veteran.md)


* ISO Maintains the copyright on the country codes, and controls it's use carefully. For futher details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.1.0/CodeSystem-ISO3166Part1.html): [DeploymentEpisodeCategoryVS](ValueSet-military-service-deployment-episode-mission-vs.md), [DeploymentEpisodeMissionVS](ValueSet-military-service-combat-episode-mission-vs.md)...Show 13 more,[DeploymentHistoryEpisode](StructureDefinition-deployment-history-episode.md),[DischargeStatusVS](ValueSet-military-service-discharge-status-vs.md),[MSHCS](CodeSystem-military-service-code-system.md),[MilitaryBranchVS](ValueSet-military-service-branch-vs.md),[MilitaryOccupation](StructureDefinition-military-service-Occupation.md),[MilitaryOccupationVS](ValueSet-military-service-military-occupation-vs.md),[MilitaryService](index.md),[MilitaryServiceEpisode](StructureDefinition-military-service-episode.md),[Observation/philip-scott-example-deployment-history-episode](Observation-philip-scott-example-deployment-history-episode.md),[PayGradeVS](ValueSet-military-service-paygrade-vs.md),[SeparationReasonVS](ValueSet-military-service-separation-reason-vs.md),[USVeteran](StructureDefinition-usveteran.md)and[USVeteranStatus](StructureDefinition-military-service-veteran-status.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.1.0/CodeSystem-v3-loinc.html): [DeploymentHistoryEpisode](StructureDefinition-deployment-history-episode.md), [MilitaryOccupation](StructureDefinition-military-service-Occupation.md)...Show 4 more,[MilitaryServiceEpisode](StructureDefinition-military-service-episode.md),[Observation/philip-scott-example-deployment-history-episode](Observation-philip-scott-example-deployment-history-episode.md),[Observation/philip-scott-example-military-occupation](Observation-philip-scott-example-military-occupation.md)and[Observation/philip-scott-example-military-service-episode](Observation-philip-scott-example-military-service-episode.md)


#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B} systems. Packages for both [R4 (hl7.fhir.us.military-service.r4)](package.r4.tgz) and [R4B (hl7.fhir.us.military-service.r4b)](package.r4b.tgz) are available.

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

