# Profile Conformance - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Profile Conformance**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Profile Conformance

* [Profile Base](#profile-base)
* [Conformance to MSH Profiles](#conformance-to-msh-profiles)
* [Element-Level Expectations](#element-level-expectations)

### Profile Base

Most MSH profiles are based on US Core profiles defined in the [US Core Implementation Guide (v3.1.1)](http://hl7.org/fhir/us/core/index.html). For example, the [US Veteran profile](StructureDefinition-usveteran.md) is based on the [US Core Patient](https://www.hl7.org/fhir/us/core/StructureDefinition-us-core-patient.html) profile. Because of the way profiles work in FHIR, any resource that validates against an MSH profile that is based a US Core profile will automatically be in compliance with the US Core profile and the associated US Core Data for Interperability (USCDI) data element required by [US regulation](https://www.healthit.gov/curesrule/).

* [Military Service Episode](StructureDefinition-military-service-episode.md) profile can be used to create Observatoin resources that describe a Veteran's military service history; it includes references to [Deployment Episode](StructureDefinition-deployment-history-episode.md) and [Military Occupation](StructureDefinition-military-service-Occupation.md).
* [Military Occupation](StructureDefinition-military-service-Occupation.md)is similar to [ODH PastOrPresentJob](http://hl7.org/fhir/us/odh/StructureDefinition-odh-PastOrPresentJob.html). It is referenced by [Military Service Episode](StructureDefinition-military-service-episode.md).

Where US Core does not provide an appropriate base profile, this implementation profiles FHIR resources directly as described below:

| | |
| :--- | :--- |
| [Deployment History Episode](StructureDefinition-deployment-history-episode.md) | No |
| [Military Occupation](StructureDefinition-military-service-Occupation.md) | No |
| [Military Service Episode](StructureDefinition-military-service-episode.md) | No |
| [US Veteran](StructureDefinition-usveteran.md) | Yes |

### Conformance to MSH Profiles

Each MSH profile expresses requirements and expectations for FHIR instances in terms of structural constraints and terminology bindings. If an instance is required to conform with an MSH profile, it MUST [validate](https://www.hl7.org/fhir/validation.html) against that profile.

#### Data Sender Expectations

Each MSH profile has a conformance statement describing what data or FHIR instances MUST or SHOULD conform to it.

#### Data Receiver Expectations

An MSH Data Receiver SHOULD perform validation on instances it receives. The Receiver first of all needs to identify which profile to use for validation. There four ways to identify the correct profile:

1. The instance is received in response to a[profile search](https://www.hl7.org/fhir/search.html#profile), so the validating profile is known in advance.
1. The instance self-identifies using`meta.profile`. Every Data Sender SHALL populate this element to specify which type of information was used/provided to consumer/receivers of military service history.
1. The Data Receiver can examine the contents of the instance to associate it with a profile (in particular, by looking for identifying code or category).
1. The Data Receiver can iteratively attempt to validate the instance against each of the Data Receiver's supported profiles.

If an instance fails validation, the Receiver may reject the instance.

### Element-Level Expectations

#### Sender and Receiver Expectations

For every element that is [required](#required-elements) and/or carries a [Must Support obligation](#must-support-obligations) (MS):

* MSH Data Senders SHALL be capable of populating the element, provided the Sender supports the profile (as indicated by its CapabilityStatement).
* If the Sender lacks the data necessary to populate the element:
* MSH Data Receivers SHALL be capable of meaningfully processing MS elements, provided the Receiver supports the profile. Depending on context, "meaningfully process" might mean displaying the data element for human use, reacting to it, or storing it for other purposes.

#### Required Elements

An MSH data element is **required** if any of the following criteria are met:

* The element is a top-level element (a first-level property of the resource) and its minimum cardinality is > 0 in the profile.
* The element not a top-level element (a second-level property or below), its minimum cardinality is > 0, and all elements directly containing that element have minimum cardinality > 0 in the profile.
* The element is not a top-level element, its minimum cardinality is > 0, and its immediate higher-level containing element exists in an **instance** attempting to conform to the profile.

In other words, a data element may be `1..1`, but if it is contained by an optional element, then it is not required unless its containing element is actually present.

#### Must Support Obligations

Interpretation of MS is not straightforward, as there is a difference between a MS **obligation** and a MS **flag**. The MS **flag** is the red S displayed on profile pages: S. A MS **obligation** means the element must be treated as described in [Sender and Receiver Expectations](#sender-and-receiver-expectations). Significantly, an MS **flag** (S) does not necessarily imply an MS **obligation**, and MS **obligations** may be attached to elements lacking MS **flags**.

To see which elements have MS flags, consult the "Snapshot Table" view of the profile. The "Differential Table" view hides MS flags inherited from the parent profile. The "Snapshot Table (Must Support)" view reflects the IG Publisher's interpretation of how MS flags translate to MS obligations, which may or may not coincide with the US Core/MSH interpretation.

The following rules apply in MSH:

* A profile without a MS flag does not have to be supported [1](#fn:1). A participant MUST declare support for optional profiles in its CapabilityStatement.
* Any MS flag or flags on an unsupported profile (as stated in participant's CapabilityStatement) do not carry MS obligations.
* An element with an MS flag does not carry an MS obligation if it is nested and any one of the elements directly containing that element lacks an MS flag. However, if the participant **elects** to support the unflagged element or elements in that hierarchy, the elements below the gap then carry an MS obligation.
* An element with an MS flag whose cardinality is 0..0 does not carry an MS obligation [2](#fn:2).
* A [required element](#required-elements) carries a MS obligation on the part of a Data Sender, regardless of whether that element has an MS flag.
* A [required element](#required-elements) without an MS flag does not carry an MS obligation for the Data Receiver [3](#fn:3).

#### Non-Must Support Elements

Data elements in MSH that **do not have** MS obligations still MAY be supported. If an element is supported, whether it has a MS flag or not, the profile must be interpreted as if the MS flag were present. For example, `Observation.category` does not have an MS flag, but a data receiver may implement the capability to display it.

1. Although not common practice, profiles can have MS flags at the data element. [↩](#fnref:1)
1. When inheriting from another profile, it is possible to set the upper cardinality to zero on an element that was MS in the parent profile. For example, you could inherit from US Core Patient, but forbid the patient’s name for privacy reasons. In this case, neither Sender nor Receiver are expected to populate or support the element – in fact, it would be an error if the element were present. [↩](#fnref:2)
1. An example is a Receiver that does not meaningfully process a required element even though it was populated by the Sender. [↩](#fnref:3)

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

