# Artifacts Summary - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

## Artifacts Summary

Contents:

*  [Structures: Resource Profiles](#1) 
*  [Structures: Extension Definitions](#2) 
*  [Terminology: Value Sets](#3) 
*  [Terminology: Code Systems](#4) 
*  [Example: Example Instances](#5) 

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Deployment History Episode](StructureDefinition-deployment-history-episode.md) | Deployment History Episode describes a completed deployment. |
| [Military Occupation](StructureDefinition-military-service-Occupation.md) | The profile reuses the ODH PastOrPresentJob profile to apply it specifically to military jobs/occupations. The observation resource that conforms to this specification is referenced by Military Service Episode. |
| [Military Service Episode](StructureDefinition-military-service-episode.md) | Military Service Episode describes a patient/veterans overall experiences of a militiary employment. The profile references military deployments and occupations as well as military branche, seperation and discharge status. A patient/Veteran may have zero or more military service episodes. The episode documents the time spent in the military organization, the dischage status and reason, and a collection of deployment episodes |
| [US Veteran](StructureDefinition-usveteran.md) | US Veteran profile extends US Core Patient profile. It's intended to be used when the patient is Veteran was confirmed by the VA. This profile includes a ['US Veteran Status'] (usveteranstatus) extension to hold status information as a boolean (i.e. 'true' indicates that the patient's veteran status was confirmed). |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [us-veteran-status](StructureDefinition-military-service-veteran-status.md) | us-veteran-status is a boolean extension used to specify whether a patient was confirmed or verified to have Veteran status. Veteran status is not limited to Combat Status but reflects the status of yes/no they had indeed served in a military organization |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Combat Episode Mission Value Set](ValueSet-military-service-combat-episode-mission-vs.md) | Example combat mission code; this is only an example data element that may be associated with a Deployment Episode, if needed. |
| [Deployment Episode Type Value Set](ValueSet-military-service-deployment-episode-mission-vs.md) | Recommended deployment episode type code - only the root concept of 'Deployment Episode' is needed for typical implementations. |
| [Discharge Status Value Set](ValueSet-military-service-discharge-status-vs.md) | Discharge Status Value Set - this value set identifies gaps in SNOMED CT. The only concept currently supported is that of 'dishonorable' discharge. |
| [Military Branch Value Set](ValueSet-military-service-branch-vs.md) | Military Branch Value Set - is a subset of the ODH Occupation value set. |
| [Military Occupation Value Set](ValueSet-military-service-military-occupation-vs.md) | Military Occupation Value Set |
| [Pay Grade Code Value Set](ValueSet-military-service-paygrade-vs.md) | Pay Grade Code Value Set - is a subset of the OHD Supervisory Role value set. Its scope is limited to military pay grade codes. |
| [Separation Reason Value Set](ValueSet-military-service-separation-reason-vs.md) | Separation Reason Value Set contains concepts that are managed as a local extensions, subject to submission to SNOMED CT. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Military Service History and Status Code System](CodeSystem-military-service-code-system.md) | Military Service History and Status Code System |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [huffman-crystal-example-veteran](Patient-huffman-crystal-example-veteran.md) | Sam Share: Veteran's patient record |
| [hugo-cross-example-veteran](Patient-hugo-cross-example-veteran.md) | Hugo Cross: Veteran's patient record |
| [philip-scott-example-deployment-history-episode](Observation-philip-scott-example-deployment-history-episode.md) | Deployment to Vietnam |
| [philip-scott-example-military-occupation](Observation-philip-scott-example-military-occupation.md) | Example Military Occupation |
| [philip-scott-example-military-service-episode](Observation-philip-scott-example-military-service-episode.md) | Military Service Episode for Veteran Example, Philip Scott |
| [philip-scott-example-veteran](Patient-philip-scott-example-veteran.md) | Phillip Scott: Veteran's patient record |

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

