# Discharge Status Value Set - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Discharge Status Value Set**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-military-service-discharge-status-vs.xml.md) 
*  [JSON](ValueSet-military-service-discharge-status-vs.json.md) 
*  [TTL](ValueSet-military-service-discharge-status-vs.ttl.md) 

## ValueSet: Discharge Status Value Set 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/ValueSet/military-service-discharge-status-vs | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:DischargeStatusVS |

 
Discharge Status Value Set - this value set identifies gaps in SNOMED CT. The only concept currently supported is that of 'dishonorable' discharge. 

 **References** 

* [Military Service Episode](StructureDefinition-military-service-episode.md)

### Logical Definition (CLD)

* Include these codes as defined in [`http://hl7.org/fhir/us/military-service/CodeSystem/military-service-code-system`](CodeSystem-military-service-code-system.md) version 📦1.0.0

 

### Expansion

Expansion performed internally based on [codesystem Military Service History and Status Code System v1.0.0 (CodeSystem)](CodeSystem-military-service-code-system.md)

This value set contains 10 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

