# Deployment Episode Type Value Set - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Deployment Episode Type Value Set**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Narrative Content](#) 
*  [XML](ValueSet-military-service-deployment-episode-mission-vs.xml.md) 
*  [JSON](ValueSet-military-service-deployment-episode-mission-vs.json.md) 
*  [TTL](ValueSet-military-service-deployment-episode-mission-vs.ttl.md) 

## ValueSet: Deployment Episode Type Value Set 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/ValueSet/military-service-deployment-episode-mission-vs | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:DeploymentEpisodeCategoryVS |

 
Recommended deployment episode type code - only the root concept of 'Deployment Episode' is needed for typical implementations. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

* Include these codes as defined in [`http://hl7.org/fhir/us/military-service/CodeSystem/military-service-code-system`](CodeSystem-military-service-code-system.md) version 📦1.0.0

 

### Expansion

Expansion performed internally based on [codesystem Military Service History and Status Code System v1.0.0 (CodeSystem)](CodeSystem-military-service-code-system.md)

This value set contains 4 concepts

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

