# US Veteran - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **US Veteran**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-usveteran-definitions.md) 
*  [Mappings](StructureDefinition-usveteran-mappings.md) 
*  [Examples](StructureDefinition-usveteran-examples.md) 
*  [XML](StructureDefinition-usveteran.profile.xml.md) 
*  [JSON](StructureDefinition-usveteran.profile.json.md) 
*  [TTL](StructureDefinition-usveteran.profile.ttl.md) 

## Resource Profile: US Veteran 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:USVeteran |

 
US Veteran profile extends US Core Patient profile. It's intended to be used when the patient is Veteran was confirmed by the VA. This profile includes a ['US Veteran Status'] (usveteranstatus) extension to hold status information as a boolean (i.e. 'true' indicates that the patient's veteran status was confirmed). 

**Usages:**

* Refer to this Profile: [Deployment History Episode](StructureDefinition-deployment-history-episode.md), [Military Occupation](StructureDefinition-military-service-Occupation.md) and [Military Service Episode](StructureDefinition-military-service-episode.md)
* Examples for this Profile: [Patient/huffman-crystal-example-veteran](Patient-huffman-crystal-example-veteran.md), [Patient/hugo-cross-example-veteran](Patient-hugo-cross-example-veteran.md) and [Patient/philip-scott-example-veteran](Patient-philip-scott-example-veteran.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.military-service|current/StructureDefinition/usveteran)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCorePatientProfile](http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-patient.html) 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCorePatientProfile](http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-patient.html) 

**Summary**

Must-Support: 1 element

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-veteran-status](StructureDefinition-military-service-veteran-status.md)

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [USCorePatientProfile](http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-patient.html) 

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [USCorePatientProfile](http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-patient.html) 

**Summary**

Must-Support: 1 element

**Extensions**

This structure refers to these extensions:

* [http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-veteran-status](StructureDefinition-military-service-veteran-status.md)

 

Other representations of profile: [CSV](StructureDefinition-usveteran.csv), [Excel](StructureDefinition-usveteran.xlsx), [Schematron](StructureDefinition-usveteran.sch) 

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

