# us-veteran-status - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **us-veteran-status**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-military-service-veteran-status-definitions.md) 
*  [Mappings](StructureDefinition-military-service-veteran-status-mappings.md) 
*  [XML](StructureDefinition-military-service-veteran-status.profile.xml.md) 
*  [JSON](StructureDefinition-military-service-veteran-status.profile.json.md) 
*  [TTL](StructureDefinition-military-service-veteran-status.profile.ttl.md) 

## Extension: us-veteran-status 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-veteran-status | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:USVeteranStatus |

us-veteran-status is a boolean extension used to specify whether a patient was confirmed or verified to have Veteran status. Veteran status is not limited to Combat Status but reflects the status of yes/no they had indeed served in a military organization

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [US Veteran](StructureDefinition-usveteran.md)
* Examples for this Extension: [Patient/huffman-crystal-example-veteran](Patient-huffman-crystal-example-veteran.md), [Patient/hugo-cross-example-veteran](Patient-hugo-cross-example-veteran.md) and [Patient/philip-scott-example-veteran](Patient-philip-scott-example-veteran.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.military-service|current/StructureDefinition/military-service-veteran-status)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: us-veteran-status is a boolean extension used to specify whether a patient was confirmed or verified to have Veteran status. Veteran status is not limited to Combat Status but reflects the status of yes/no they had indeed served in a military organization

 **Differential View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

 **Snapshot View** 

This structure is derived from [Extension](http://hl7.org/fhir/R4/extensibility.html#Extension) 

**Summary**

Simple Extension with the type boolean: us-veteran-status is a boolean extension used to specify whether a patient was confirmed or verified to have Veteran status. Veteran status is not limited to Combat Status but reflects the status of yes/no they had indeed served in a military organization

 

Other representations of profile: [CSV](StructureDefinition-military-service-veteran-status.csv), [Excel](StructureDefinition-military-service-veteran-status.xlsx), [Schematron](StructureDefinition-military-service-veteran-status.sch) 

#### Constraints

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

