# Military Service Episode - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Military Service Episode**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-military-service-episode-definitions.md) 
*  [Mappings](StructureDefinition-military-service-episode-mappings.md) 
*  [Examples](StructureDefinition-military-service-episode-examples.md) 
*  [XML](StructureDefinition-military-service-episode.profile.xml.md) 
*  [JSON](StructureDefinition-military-service-episode.profile.json.md) 
*  [TTL](StructureDefinition-military-service-episode.profile.ttl.md) 

## Resource Profile: Military Service Episode 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-episode | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:MilitaryServiceEpisode |

 
Military Service Episode describes a patient/veterans overall experiences of a militiary employment. The profile references military deployments and occupations as well as military branche, seperation and discharge status. A patient/Veteran may have zero or more military service episodes. The episode documents the time spent in the military organization, the dischage status and reason, and a collection of deployment episodes 

**Usages:**

* Examples for this Profile: [Observation/philip-scott-example-military-service-episode](Observation-philip-scott-example-military-service-episode.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.military-service|current/StructureDefinition/military-service-episode)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 8 elements(1 nested mandatory element)
 Must-Support: 12 elements
 Prohibited: 14 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)
* [Deployment History Episode(http://hl7.org/fhir/us/military-service/StructureDefinition/deployment-history-episode)](StructureDefinition-deployment-history-episode.md)
* [Military Occupation(http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-Occupation)](StructureDefinition-military-service-Occupation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.hasMember
* The element 1 is sliced based on the value of Observation.component

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 8 elements(1 nested mandatory element)
 Must-Support: 12 elements
 Prohibited: 14 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)
* [Deployment History Episode(http://hl7.org/fhir/us/military-service/StructureDefinition/deployment-history-episode)](StructureDefinition-deployment-history-episode.md)
* [Military Occupation(http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-Occupation)](StructureDefinition-military-service-Occupation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.hasMember
* The element 1 is sliced based on the value of Observation.component

 

Other representations of profile: [CSV](StructureDefinition-military-service-episode.csv), [Excel](StructureDefinition-military-service-episode.xlsx), [Schematron](StructureDefinition-military-service-episode.sch) 

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

