# Military Occupation - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Military Occupation**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-military-service-Occupation-definitions.md) 
*  [Mappings](StructureDefinition-military-service-Occupation-mappings.md) 
*  [Examples](StructureDefinition-military-service-Occupation-examples.md) 
*  [XML](StructureDefinition-military-service-Occupation.profile.xml.md) 
*  [JSON](StructureDefinition-military-service-Occupation.profile.json.md) 
*  [TTL](StructureDefinition-military-service-Occupation.profile.ttl.md) 

## Resource Profile: Military Occupation 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-Occupation | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:MilitaryOccupation |

 
The profile reuses the ODH PastOrPresentJob profile to apply it specifically to military jobs/occupations. The observation resource that conforms to this specification is referenced by Military Service Episode. 

**Usages:**

* Refer to this Profile: [Deployment History Episode](StructureDefinition-deployment-history-episode.md) and [Military Service Episode](StructureDefinition-military-service-episode.md)
* Examples for this Profile: [Observation/philip-scott-example-military-occupation](Observation-philip-scott-example-military-occupation.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.military-service|current/StructureDefinition/military-service-Occupation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 8 elements
 Must-Support: 9 elements
 Prohibited: 13 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.value[x]
* The element 1 is sliced based on the value of Observation.component

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 8 elements
 Must-Support: 9 elements
 Prohibited: 13 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.value[x]
* The element 1 is sliced based on the value of Observation.component

 

Other representations of profile: [CSV](StructureDefinition-military-service-Occupation.csv), [Excel](StructureDefinition-military-service-Occupation.xlsx), [Schematron](StructureDefinition-military-service-Occupation.sch) 

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

