# Deployment History Episode - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Deployment History Episode**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Content](#) 
*  [Detailed Descriptions](StructureDefinition-deployment-history-episode-definitions.md) 
*  [Mappings](StructureDefinition-deployment-history-episode-mappings.md) 
*  [Examples](StructureDefinition-deployment-history-episode-examples.md) 
*  [XML](StructureDefinition-deployment-history-episode.profile.xml.md) 
*  [JSON](StructureDefinition-deployment-history-episode.profile.json.md) 
*  [TTL](StructureDefinition-deployment-history-episode.profile.ttl.md) 

## Resource Profile: Deployment History Episode 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.org/fhir/us/military-service/StructureDefinition/deployment-history-episode | *Version*:1.0.0 |
| Active as of 2025-10-06 | *Computable Name*:DeploymentHistoryEpisode |

 
Deployment History Episode describes a completed deployment. 

**Usages:**

* Refer to this Profile: [Military Service Episode](StructureDefinition-military-service-episode.md)
* Examples for this Profile: [Observation/philip-scott-example-deployment-history-episode](Observation-philip-scott-example-deployment-history-episode.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.military-service|current/StructureDefinition/deployment-history-episode)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

*  [Key Elements Table](#tabs-key) 
*  [Differential Table](#tabs-diff) 
*  [Snapshot Table](#tabs-snap) 
*  [Statistics/References](#tabs-summ) 
*  [All](#tabs-all) 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 12 elements(1 nested mandatory element)
 Must-Support: 8 elements
 Prohibited: 18 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)
* [Military Occupation(http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-Occupation)](StructureDefinition-military-service-Occupation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.hasMember
* The element 1 is sliced based on the value of Observation.component

 **Key Elements View** 

#### Terminology Bindings

#### Constraints

 **Differential View** 

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

#### Terminology Bindings (Differential)

 **Snapshot View** 

#### Terminology Bindings

#### Constraints

This structure is derived from [Observation](http://hl7.org/fhir/R4/observation.html) 

**Summary**

Mandatory: 12 elements(1 nested mandatory element)
 Must-Support: 8 elements
 Prohibited: 18 elements

**Structures**

This structure refers to these other structures:

* [US Veteran(http://hl7.org/fhir/us/military-service/StructureDefinition/usveteran)](StructureDefinition-usveteran.md)
* [Military Occupation(http://hl7.org/fhir/us/military-service/StructureDefinition/military-service-Occupation)](StructureDefinition-military-service-Occupation.md)

**Slices**

This structure defines the following [Slices](http://hl7.org/fhir/R4/profiling.html#slices):

* The element 1 is sliced based on the value of Observation.effective[x]
* The element 1 is sliced based on the value of Observation.hasMember
* The element 1 is sliced based on the value of Observation.component

 

Other representations of profile: [CSV](StructureDefinition-deployment-history-episode.csv), [Excel](StructureDefinition-deployment-history-episode.xlsx), [Schematron](StructureDefinition-deployment-history-episode.sch) 

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

