# huffman-crystal-example-veteran - HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1 v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **huffman-crystal-example-veteran**

HL7 FHIR Implementation Guide: Military Service History and Status Release 1 - US Realm | STU1, published by Cross Group Projects WG. This guide is not an authorized publication; it is the continuous build for version 1.0.0 built by the FHIR (HL7® FHIR® Standard) CI Build. This version is based on the current content of [https://github.com/HL7/fhir-military-service/](https://github.com/HL7/fhir-military-service/) and changes regularly. See the [Directory of published versions](http://hl7.org/fhir/us/military-service/history.html)

*  [Narrative Content](#) 
*  [XML](Patient-huffman-crystal-example-veteran.xml.md) 
*  [JSON](Patient-huffman-crystal-example-veteran.json.md) 
*  [TTL](Patient-huffman-crystal-example-veteran.ttl.md) 

## Example Patient: huffman-crystal-example-veteran

Profile: [US Veteran](StructureDefinition-usveteran.md)

Crystal Example Huffman Female, DoB: 1992-02-20 ( Medical Record Number: 1032702 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Contact Detail | * ph: 555-555-5555(Home)
* [sam.share@veterans-org.com](mailto:sam.share@veterans-org.com)
* 49 Pleasant Hill St Anytowm NH 03088 US 
* 183 Mountain View St Anytown NH 03088 US 
 |
| [us-veteran-status](StructureDefinition-military-service-veteran-status.md) | true |
| US Core Ethnicity Extension: | * ombCategory: [Race & Ethnicity - CDC 2135-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2135-2): Hispanic or Latino
* text: Hispanic or Latino
* detailed: [Race & Ethnicity - CDC 2184-0](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2184-0): Dominican
 |
| [US Core Birth Sex Extension](http://hl7.org/fhir/us/core/STU5.0.1/StructureDefinition-us-core-birthsex.html) | M |
| US Core Race Extension: | * ombCategory: [Race & Ethnicity - CDC 2106-3](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2106-3): White
* text: Mixed
* detailed: [Race & Ethnicity - CDC 2036-2](http://hl7.org/fhir/us/core/STU3.1.1/CodeSystem-cdcrec.html#cdcrec-2036-2): Filipino
 |

 IG © 2020+ [Cross Group Projects WG](http://www.hl7.org/Special/committees/cgp). Package hl7.fhir.us.military-service#1.0.0 based on [FHIR 4.0.1](http://hl7.org/fhir/R4/). Generated 2025-10-06 
 Links:[Table of Contents](toc.md)|[QA Report](qa.md)|[Version History](http://hl7.org/fhir/us/military-service/history.html)|![](cc0.png)|[Propose a change](http://hl7.org/fhir-issues) 

