# Specification - Health Care Surveys Reporting v2.0.0

## Specification

This section defines the specific requirements for systems wishing to conform to actors specified in this Health Care Surveys Content Implementation Guide (IG). The specification focuses on using the eCR Now FHIR App-Health Care Surveys to report the health care survey data to National Center for Health Statistics (NCHS) data stores.

### Pre-reading

Before reading this formal specification, implementers should first be familiar with the [Background](background.md) page which provides the business context and general process flow.

### Conventions

This IG uses specific terminology to flag statements that have relevance for the evaluation of conformance with the guide:

* **SHALL** indicates requirements that must be met to be conformant with the specification.
* **SHOULD** indicates behaviors that are strongly recommended (and which may result in interoperability issues or sub-optimal behavior if not adhered to), but which do not, for this version of the specification, affect the determination of specification conformance.
* **MAY** describes optional behaviors that are free to consider but where there is no recommendation for or against adoption.

### Claiming Conformance

Actors and Systems asserting conformance to this IG must implement the requirements outlined in the corresponding capability statements. The following definition of Must Support is to be used in the implementation of the requirements.

#### Must Support Definition

* §HCS-1:Systems **SHALL** be capable of populating data elements as specified by the profiles and data elements are returned using the specified APIs in the capability statement.§
* §HCS-2:Systems **SHALL** be capable of processing resource instances containing the Must Support data elements without generating an error or causing the application to fail.§
* §HCS-3:Systems **SHOULD** be capable of displaying the Must Support data elements for human use or storing them for other purposes.§
* §HCS-4:In situations where information on a particular data element is not present and the reason for absence is unknown, Systems **SHALL NOT** include the data elements in the resource instance returned from executing the API requests.§
* §HCS-5:When accessing Health Care Surveys Content IG data, Systems **SHALL** interpret missing data elements within resource instances returned from API requests as data not present.§
* §HCS-6:When data is not available for any of the mandatory elements specified in the IG, a data absent reason extension **SHOULD** be added to satisfy the requirement along with an appropriate value from the [data-absent-reason value set](http://hl7.org/fhir/ValueSet/data-absent-reason).§

### Profiles and Other IGs Used by the Specification

This specification makes significant use of [FHIR profiles](http://hl7.org/fhir/R4/profiling.html), search parameter definitions, and terminology artifacts to describe the content to be shared as part of Health Care Surveys Content IG workflows. The IG is based on [FHIR R4](http://hl7.org/fhir/R4/) and profiles are listed for each interaction.

The full set of profiles defined in this IG can be found by following the links on the [FHIR Artifacts](artifacts.md) page.

#### US Core Usage

This IG leverages the [US Core](http://hl7.org/fhir/us/core/STU6.1/index.html) set of profiles defined by HL7 for sharing non-veterinary electronic medical record (EMR) individual health data in the U.S. Where US Core profiles exist, this IG either leverages them directly or uses them as a base for any additional constraints needed to support the research use cases. If no constraints are needed, this IG does not define any profiles.

#### SMART App Launch IG Usage

This IG leverages the [SMART App Launch IG](http://hl7.org/fhir/smart-app-launch/STU2.2/index.html) defined by HL7 Infrastructure WG for enabling authentication and authorization between various actors involved in the workflows. This IG leverages Substitutable Medical Applications, Reusable Technologies (SMART) on FHIR Backend Services Authorization requirements.

### Implementation Requirements

#### SMART on FHIR Backend Services Requirements

This section outlines how the SMART on FHIR Backend Services Authorization will be used by the Health Care Surveys Content IG.

* The system actors namely Data Source, eCR Now FHIR App-Health Care Surveys and the NCHS Data Store are required to use the SMART on FHIR Backend Services Authorization mechanisms as outlined below for the following interactions:
* §HCS-7:System actors acting as servers (e.g., electronic health record (EHR) and NCHS Data Store) **SHALL** advertise conformance to SMART on FHIR Backend Services by hosting Well-Known Uniform Resource Identifiers (URIs) as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.§
* §HCS-8:System actors acting as servers **SHALL** include token_endpoint, scopes_supported, token_endpoint_auth_methods_supported and token_endpoint_auth_signing_alg_values_supported as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.§
* §HCS-9:When System actors act as clients (e.g., eCR Now FHIR App-Health Care Surveys), they **SHALL** share their JSON Web Key Set (JWKS) with the server System actors (e.g., EHR and NCHS Data Store) using Uniform Resource Locators (URLs) as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.§
* §HCS-10:System actors acting as clients **SHALL** obtain the access token as defined in the [SMART App Launch IG Backend Services](http://hl7.org/fhir/smart-app-launch/STU2.2/backend-services.html) specification.§
* §HCS-11:For the Health Care Survey use cases, Data Sources **SHALL** support the system/*.read scopes.§
* §HCS-12:The NCHS Data Store **SHALL** support the system/**.read and system/**.write scopes.§
* §HCS-13:The health care organization's existing processes along with the Data Source's authorization server **SHALL** verify any organizational policy requirements (for example, registration of the eCR Now FHIR App-Health Care Surveys, authorizing requested scopes, testing and verification of eCR Now FHIR App-Health Care Surveys implementation in sandbox environment prior to production) before allowing the eCR Now FHIR App-Health Care Surveys to access the data to be included in the health care survey report.§

#### Knowledge Artifact and Knowledge Artifact Repository Requirements

* §HCS-14:The NCHS Data Store **SHALL** create a Knowledge Artifact§
* §HCS-15:The NCHS Data Store **SHALL** publish the Group Resource containing the list of all the Practitioners participating in the health care survey. This can be published in the NCHS Data Store FHIR Server or a separate Knowledge Artifact Repository.§
* §HCS-16:The NCHS Data Store **SHALL** republish the Group Resource when the list of all the Practitioners participating in the health care survey changes.§
* §HCS-17:The NCHS Data Store **SHALL** create the Knowledge Artifact following the constraints.§
* §HCS-18:The NCHS Data Store **SHALL** implement the Knowledge Artifact Repository requirements.§

#### Data Source Requirements

* §HCS-19:The Data Source (e.g., EHR, clinical data repository) **SHALL** support the requirements as outlined in the [Data Source Capability Statement](CapabilityStatement-health-care-surveys-reporting-data-source.md).§

##### Authorization Requirements

* §HCS-20:The Data Source **SHALL** support the [SMART on FHIR Backend Services Authorization](specification.md#smart-on-fhir-backend-services-requirements) outlined above as a Server.§

##### Subscription Requirements

* §HCS-21:The Data Source **SHALL** support the creation of Subscriptions.§
* §HCS-22:The Data Source **SHALL** support [`rest-hook`](http://hl7.org/fhir/R4/subscription.html#2.46.7.1) Subscription channel to notify the eCR Now FHIR App-Health Care Surveys.§
* §HCS-23:The Data Source **SHALL** support Notification Bundles with [`full resource payload`](http://hl7.org/fhir/uv/subscriptions-backport/STU1.1/payloads.html#full-resource) as outlined in the Backport Subscriptions IG.§
* §HCS-24:For the Health Care Surveys Content IG, the Data Source **SHALL** include the Encounter resource which was closed as part of the Notification Bundle.§
* §HCS-25:The Data Source **SHALL** support operations and APIs for Subscription, Notification Bundle, Subscription status resources as outlined in the [Data Source Capability Statement](CapabilityStatement-health-care-surveys-reporting-data-source.md).§

##### Data API Requirements

* §HCS-26:The Data Source **SHALL** support the [US Core Server APIs](http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server) and MedicationAdministration APIs as outlined in the [EHR Capability Statement](CapabilityStatement-health-care-surveys-reporting-data-source.md) for the eCR Now FHIR App-Health Care Surveys to access patient data.§

#### eCR Now FHIR App-Health Care Surveys Requirements

##### Authorization Requirements

* §HCS-27:The eCR Now FHIR App-Health Care Surveys **SHALL** support the [SMART on FHIR Backend Services Authorization](specification.md#smart-on-fhir-backend-services-requirements) outlined above as a client.§

##### Subscription Requirements

* §HCS-28:The eCR Now FHIR App-Health Care Surveys **SHALL** create Subscriptions.§
* §HCS-29:The eCR Now FHIR App-Health Care Surveys **SHALL** support [`rest-hook`](http://hl7.org/fhir/R4/subscription.html#2.46.7.1) Subscription channel to receive notifications from the Data Source.§

##### Subscription Notification API

* §HCS-30:The eCR Now FHIR App-Health Care Surveys **SHALL** support a POST API <BSA Base URL>/receive-notification with a payload of the Subscription Notification Bundle to receive the notifications from the Data Source.§

##### Knowledge Artifact Processing Requirements

* §HCS-31:The eCR Now FHIR App-Health Care Surveys **SHALL** allow the health care organization to activate/deactivate a specific Knowledge Artifact. Activation indicates applying the Knowledge Artifact and deactivation indicates not applying the Knowledge Artifact for events occurring within the health care organization.§
* §HCS-32:The eCR Now FHIR App-Health Care Surveys **SHALL** process the Health Care Surveys Knowledge Artifact and create Subscription resources in the Data Source for each trigger event.§
* §HCS-33:For the health care surveys, the eCR Now FHIR App-Health Care Surveys **SHALL** create the Subscription.§
* §HCS-34:Upon deactivation of a Knowledge Artifact, The eCR Now FHIR App-Health Care Surveys **SHALL** delete the Subscriptions previously created by the eCR Now FHIR App-Health Care Surveys for the Knowledge Artifact (e.g., delete the Subscription created for encounter-end trigger event).§
* §HCS-35:The eCR Now FHIR App-Health Care Surveys **SHALL** implement FhirPath expression processing to process the Health Care Surveys Knowledge Artifact actions.§
* §HCS-36:The eCR Now FHIR App-Health Care Surveys **SHALL** use the default queries outlined by the Health Care Surveys Knowledge Artifact unless overridden by the health care organization.§
* §HCS-37:The eCR Now FHIR App-Health Care Surveys **SHALL** ensure no duplicate reports are submitted for the same patient and encounter occurring within a health care organization.§

##### Data API Requirements

* §HCS-38:The eCR Now FHIR App-Health Care Surveys acting as a client **SHALL** use the [US Core Server APIs](http://hl7.org/fhir/us/core/CapabilityStatement/us-core-server) and MedicationAdministration APIs as outlined in the [Data Source Capability Statement](CapabilityStatement-health-care-surveys-reporting-data-source.md) to access patient data from the Data Source.§

##### Report Generation Requirements

* §HCS-39:The eCR Now FHIR App-Health Care Surveys **SHALL** create a health care survey report following the constraints identified in [Health Care Survey Content Bundle](StructureDefinition-hcs-content-bundle.md).§
* §HCS-40:The eCR Now FHIR App-Health Care Surveys **SHALL** package the health care survey report following the constraints identified in [Health Care Survey Reporting Bundle](StructureDefinition-hcs-reporting-bundle.md).§
* §HCS-41:The eCR Now FHIR App-Health Care Surveys **SHALL** submit the message containing the health care survey report to the endpoint identified in the Health Care Surveys Knowledge Artifact unless overridden by the health care organization.§

##### Use of Non-FHIR Based Approaches to Submit the Health Care Surveys Report

* §HCS-42:The eCR Now FHIR App-Health Care Surveys **MAY** use other transport methods such as Direct Transport to submit the Health Care Survey Report created when appropriate.§

##### Message Receiving and Processing Requirements

* §HCS-43:The NCHS Data Store **SHALL** implement the $process-message operation on the ROOT URL of the FHIR Server to receive reports from the Backend Service App using the POST operation.§
* §HCS-44:Upon receipt of the message, the NCHS Data Store **SHALL** validate the message before accepting the message.§
* §HCS-45:When there are validation failures, the NCHS Data Store **SHALL** return a Operation Outcome response with the details of the validations as part of the POST response.§
* §HCS-46:The NCHS Data Store **SHALL** implement the PHA requirements.§

### Conformance Statements in this Guide

§§§

