# Health Care Surveys Content Bundle - Health Care Surveys Reporting v2.0.0

## Resource Profile: Health Care Surveys Content Bundle 

 
Bundle Resource profile for health care surveys report content. This bundle is always part of the Health Care Surveys Reporting Bundle and organizes the information using a Composition resource and will contain all the resources referenced from a Composition resource. 

**Usages:**

* Use this Profile: [Health Care Surveys Reporting Bundle](StructureDefinition-hcs-reporting-bundle.md)
* Examples for this Profile: [Bundle/hcs-content-bundle-example](Bundle-hcs-content-bundle-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.health-care-surveys-reporting|current/StructureDefinition/hcs-content-bundle)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-hcs-content-bundle.csv), [Excel](../StructureDefinition-hcs-content-bundle.xlsx), [Schematron](../StructureDefinition-hcs-content-bundle.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hcs-content-bundle",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-content-bundle",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.59.42.2"
    }
  ],
  "version" : "2.0.0",
  "name" : "HealthcareSurveysContentBundle",
  "title" : "Health Care Surveys Content Bundle",
  "status" : "active",
  "date" : "2026-01-21T01:15:19+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "Bundle Resource profile for health care surveys report content. This bundle is always part of the Health Care Surveys Reporting Bundle and organizes the information using a Composition resource and will contain all the resources referenced from a Composition resource.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-composition"
            ]
          }
        ]
      }
    ]
  }
}

```
