# Health Care Surveys Composition - Health Care Surveys Reporting v2.0.0

## Resource Profile: Health Care Surveys Composition 

 
This Composition profile is used to organize the healthcare survey report content. 

### Introduction

This profile is used to represent the clinical content present within a health care survey report.

### Sections and Population Criteria

The following sections and population criteria should be used to create the composition resource below.

To support reduction in Bundle sizes and limit duplicate data, in most cases data should be limited to the current encounter.

* Patient: The patient who is the subject of the encounter
* Encounter: The encounter that was closed (updated documentation to be added to the encounter before stating it is closed)
* Conditions/Problems/HealthConcerns: 
* Encounter diagnosis for the closed encounter
* All statuses except inactive; verificationStatus = confirmed
 
* MedicationRequests: Medication requested during the encounter with status = active and completed; intent = order.
* MedicationAdministration: Medication administered during the encounter with status = active.
* Medications: Medications referenced by MedicationRequests and MedicationAdministration.
* Vital Signs: Vital signs for the encounter with status = final or status = amended.
* Allergies: Allergies associated with the patient with status = active; verificationStatus = confirmed.
* Procedures: All interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient historically at the time the document is generated. The section should include notable procedures, but can contain all procedures for the period of time being summarized.
* ServiceRequest: Procedures ordered during the encounter.
* Immunizations: Immunizations associated with the patient.
* LabResults: Results linked to the encounter, ordered during the encounter, received during the encounter, or received within a specified timeframe (e.g., 48 - 72 hours) after the encounter closes with status = final or status = preliminary.
* Lab Reporting: Results linked to the encounter, ordered during the encounter, received during the encounter, or received within a specified timeframe (e.g., 48 - 72 hours) after the encounter closes with status = final or status = preliminary.
* Diagnostic Report Notes: 
* Results linked to the encounter, ordered during the encounter, received during the encounter, or received within a specified timeframe (e.g., 48 - 72 hours) after the encounter closes with status = final or status = preliminary.
* Procedure Notes.
* Imaging data is NOT to be sent.
 
* Clinical Notes: All notes created during the encounter.
* Care Team: Associated with the patient with status = active.
* CarePlan: Associated with the encounter with status = draft or status = active.
* Goals: status = proposed or status = planned or status = accepted or status = active.
* Smoking Status: Associated with the patient.
* Implantable Devices: Associated with the patient.
* Pregnancy Status: Associated with the patient.

The above data to be populated by the implementers of the DataSource actor.

### USCDI Mappings

[USCDI V3.1](https://www.healthit.gov/isp/united-states-core-data-interoperability-uscdi#uscdi-v3-1) mappings are noted in the Descriptions & Constraints section of the profile below. For comprehensive mappings see [US Core USCDI Guidance](http://hl7.org/fhir/us/core/STU6.1/uscdi.html) (note that US Core 6.1.0 was published prior to USCDI V3.1 so the mappings are to USCDI V3.0).

The following two profiles are not specifically constrained in the Composition but can be used or are referenced as stated below:

* [US Core RelatedPerson Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-relatedperson.html) (USCDI Data Class: Patient Demographics | USCDI Data Elements: Related Person's Name, Related Person's Relationship) is referenced from the following US Core Profiles: 
* [US Core CareTeam Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careplan.html), [US Core Coverage Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-coverage.html), [US Core DocumentReference Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-documentreference.html), [US Core Encounter Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-encounter.html), [US Core MedicationDispense Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medicationdispense.html), [US Core MedicationRequest Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medicationrequest.html), [US Core Observation Screening Assessment Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-screening-assessment.html), [US Core Provenance Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-provenance.html), [US Core QuestionnaireResponse Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-questionnaireresponse.html), [US Core ServiceRequest Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html) and [US Core Simple Observation Profile](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-simple-observation.html)
 
* [US Core Provenance Profile](http://hl7.org/fhir/us/core/STU6.1/) (USCDI Data Class: Provenance | USCDI Data Elements: Author Time Stamp, Author Organization) is supported for the following US Core resources: 
* AllergyIntolerance, CarePlan, CareTeam, Condition, Coverage, Device, DiagnosticReport, DocumentReference, Encounter, Goal, Immunization, MedicationDispense, MedicationRequest, Observation, Patient, Procedure, QuestionnaireResponse, RelatedPerson, ServiceRequest
 

**Usages:**

* Use this Profile: [Health Care Surveys Content Bundle](StructureDefinition-hcs-content-bundle.md)
* Examples for this Profile: [Composition/hcs-composition-example](Composition-hcs-composition-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.health-care-surveys-reporting|current/StructureDefinition/hcs-composition)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-hcs-composition.csv), [Excel](../StructureDefinition-hcs-composition.xlsx), [Schematron](../StructureDefinition-hcs-composition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hcs-composition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-composition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.59.42.1"
    }
  ],
  "version" : "2.0.0",
  "name" : "HealthCareSurveysComposition",
  "title" : "Health Care Surveys Composition",
  "status" : "active",
  "date" : "2026-01-21T01:15:19+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This Composition profile is used to organize the healthcare survey report content.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Health Care Surveys Composition",
        "definition" : "The Health Care Surveys Composition profile establishes the core elements, extensions, vocabularies and value sets for representing heath care surveys. "
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Health Care Surveys Composition identifier",
        "definition" : "Health Care Surveys Composition identifier. This is equivalent to ClinicalDocument.setId in CDA. The identifier of the containing Bundle is equivalent to ClinicalDocument.id in CDA. ",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "fixedCode" : "final",
        "mustSupport" : true
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "National Health Care Surveys report",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "75619-7"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "short" : "Patient who is the subject of the report.",
        "definition" : "This Patient profile represents the subject of the healthcare survey report.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Encounter related to the public health event",
        "definition" : "This Encounter profile represents the encounter related to the healthcare survey report.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "mustSupport" : true
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "The author(s) of the document",
        "definition" : "It is possible to have multiple authors - especially in the case where the default author is the organization. Author information can contain the \"eCR Now FHIR App-Health Care Surveys\" as a Device Author. ",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitionerrole|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-practitioner|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "fixedString" : "National Health Care Surveys report",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section",
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-explicit-type-name",
            "valueString" : "Section"
          }
        ],
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "min" : 3,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:reasonForVisitSection",
        "path" : "Composition.section",
        "sliceName" : "reasonForVisitSection",
        "short" : "Reason for Visit Section",
        "definition" : "This section records the reason for the patient's visit (the provider’s description of the reason for visit).",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:reasonForVisitSection.code",
        "path" : "Composition.section.code",
        "short" : "Reason for Visit code",
        "definition" : "Reason for Visit code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29299-5"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:reasonForVisitSection.text",
        "path" : "Composition.section.text",
        "short" : "Reason for Visit narrative",
        "definition" : "Reason for Visit narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection",
        "path" : "Composition.section",
        "sliceName" : "problemSection",
        "short" : "Problem Section (USCDI Data Class: Problems, Encounter)",
        "definition" : "This section lists and describes all the patient's current problems on the maintained problem list.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection.code",
        "path" : "Composition.section.code",
        "short" : "Problem Section code",
        "definition" : "Problem Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection.text",
        "path" : "Composition.section.text",
        "short" : "Problem Section narrative",
        "definition" : "Problem Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection.entry:problemsHealthConcerns",
        "path" : "Composition.section.entry",
        "sliceName" : "problemsHealthConcerns",
        "short" : "Problems Health Concerns Entries (USCDI Data Elements: Date of Resolution, Date of Diagnosis, SDOH Problems/Health Concerns, Health Concerns, Disability Status, Functional Status, Mental/Cognitive Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:problemSection.entry:encounterDiagnosis",
        "path" : "Composition.section.entry",
        "sliceName" : "encounterDiagnosis",
        "short" : "Encounter Diagnosis Entries (USCDI Data Elements: Encounter Diagnosis)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-encounter-diagnosis|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:allergiesSection",
        "path" : "Composition.section",
        "sliceName" : "allergiesSection",
        "short" : "Allergies Section (USCDI Data Class: Allergies and Intolerances)",
        "definition" : "This section lists and describes all the patient's current allergies on the maintained allergy list.",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:allergiesSection.code",
        "path" : "Composition.section.code",
        "short" : "Allergies Section code",
        "definition" : "Allergies Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:allergiesSection.text",
        "path" : "Composition.section.text",
        "short" : "Allergies Section narrative",
        "definition" : "Allergies Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:allergiesSection.entry",
        "path" : "Composition.section.entry",
        "short" : "AllergyIntolerance Entries (USCDI Data Elements: Substance (Medication), Substance (Drug Class), Reaction)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-allergyintolerance|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection",
        "path" : "Composition.section",
        "sliceName" : "assessmentAndPlanOfTreatmentSection",
        "short" : "Assessment Section (USCDI Data Class: Assessment and Plan of Treatment, Health Status/Assessments)",
        "definition" : "Health professional’s conclusions and working assumptions that will guide treatment of the patient.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.code",
        "path" : "Composition.section.code",
        "short" : "Assessment and Plan of Treatment Section code",
        "definition" : "Assessment and Plan of Treatment Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "51847-2"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.text",
        "path" : "Composition.section.text",
        "short" : "Evaluation + Plan note",
        "definition" : "Evaluation + Plan note",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.entry:screeningAssessment",
        "path" : "Composition.section.entry",
        "sliceName" : "screeningAssessment",
        "short" : "Assessment Entries (USCDI Data Elements: SDOH Assessment, Functional Status, Disability Status, Mental/Cogntive Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-screening-assessment",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-simple-observation"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.entry:questionnaireResponse",
        "path" : "Composition.section.entry",
        "sliceName" : "questionnaireResponse",
        "short" : "QuestionnaireResponse Entries (USCDI Data Elements: SDOH Assessment, Functional Status, Disability Status, Mental/Cogntive Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-questionnaireresponse|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:assessmentAndPlanOfTreatmentSection.entry:carePlan",
        "path" : "Composition.section.entry",
        "sliceName" : "carePlan",
        "short" : "CarePlan Entries (USCDI Data Elements: Assessment and Plan of Treatment)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careplan|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:careTeamSection",
        "path" : "Composition.section",
        "sliceName" : "careTeamSection",
        "short" : "Care Team Section (USCDI Data Class: Care Team Members)",
        "definition" : "This section lists and describes all the patient's current care team members.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:careTeamSection.code",
        "path" : "Composition.section.code",
        "short" : "Care Team Section code",
        "definition" : "Care Team Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85847-2"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:careTeamSection.text",
        "path" : "Composition.section.text",
        "short" : "Care Team Section narrative",
        "definition" : "Care Team Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:careTeamSection.entry",
        "path" : "Composition.section.entry",
        "short" : "Care Team Entries (USCDI Data Elements: Care Team Members - Name, Identifier, Location, Telecom, Role)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:coverageSection",
        "path" : "Composition.section",
        "sliceName" : "coverageSection",
        "short" : "Coverage Section (USCDI Data Class: Health Insurance Information)",
        "definition" : "This section lists the patient's coverage.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:coverageSection.code",
        "path" : "Composition.section.code",
        "short" : "Coverage Section code",
        "definition" : "Coverage Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48768-6"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:coverageSection.text",
        "path" : "Composition.section.text",
        "short" : "Coverage Section narrative",
        "definition" : "Coverage Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:coverageSection.entry",
        "path" : "Composition.section.entry",
        "short" : "Coverage Entries (USCDI Data Elements: Coverage Status, Coverage Type, Relationship to Subscriber, Member Identifier, Subscriber Identifier, Group Number, Payer Identifier)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:goalsSection",
        "path" : "Composition.section",
        "sliceName" : "goalsSection",
        "short" : "Goals Section (USCDI Data Class: Goals)",
        "definition" : "This section lists and describes the patient's goals.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:goalsSection.code",
        "path" : "Composition.section.code",
        "short" : "Goals Section code",
        "definition" : "Goals Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "61146-7"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:goalsSection.text",
        "path" : "Composition.section.text",
        "short" : "Goals Section narrative",
        "definition" : "Goals Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:goalsSection.entry",
        "path" : "Composition.section.entry",
        "short" : "Goal Entries (USCDI Data Elements: Patient Goals, SDOH Goals)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:immunizationsSection",
        "path" : "Composition.section",
        "sliceName" : "immunizationsSection",
        "short" : "Immunizations Section (USCDI Data Class: Immunization)",
        "definition" : "The Immunizations Section defines a patient's current immunization status and pertinent immunization history. The primary use case for the Immunization Section is to enable communication of a patient's immunization status. The section should include current immunization status, and may contain the entire immunization history that is relevant to the period of time being summarized.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:immunizationsSection.code",
        "path" : "Composition.section.code",
        "short" : "Immunizations code",
        "definition" : "Immunizations code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11369-6"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:immunizationsSection.text",
        "path" : "Composition.section.text",
        "short" : "Immunizations narrative",
        "definition" : "Immunizations narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:immunizationsSection.entry",
        "path" : "Composition.section.entry",
        "short" : "Immunization Entries (USCDI Data Elements: Immunizations)",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicalEquipmentSection",
        "path" : "Composition.section",
        "sliceName" : "medicalEquipmentSection",
        "short" : "Medical Equipment Section (USCDI Data Class: Unique Device Identifier(s) for a patient's implantable device(s))",
        "definition" : "This section lists and describes all the patient's current implanted devices.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicalEquipmentSection.code",
        "path" : "Composition.section.code",
        "short" : "Medical Equipment Section code",
        "definition" : "Medical Equipment Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "46264-8"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicalEquipmentSection.text",
        "path" : "Composition.section.text",
        "short" : "Medical Equipment Section narrative",
        "definition" : "Medical Equipment Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicalEquipmentSection.entry",
        "path" : "Composition.section.entry",
        "short" : "Implantable Device Entries (USCDI Data Elements: Unique Device Identifier(s) for a patient's implantable device(s))",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection",
        "path" : "Composition.section",
        "sliceName" : "medicationsSection",
        "short" : "Medications Section (USCDI Data Class: Medications)",
        "definition" : "The Medications Section contains a patient's current medications and pertinent medication history. At a minimum, the currently active medications are listed.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.code",
        "path" : "Composition.section.code",
        "short" : "Medications Section code",
        "definition" : "Medications Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10160-0"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.text",
        "path" : "Composition.section.text",
        "short" : "Medications Section narrative",
        "definition" : "Medications Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.entry:medicationAdministration",
        "path" : "Composition.section.entry",
        "sliceName" : "medicationAdministration",
        "short" : "MedicationAdministration Entries (USCDI Data Elements: Medications, Dose)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-medicationadministration"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.entry:medicationRequest",
        "path" : "Composition.section.entry",
        "sliceName" : "medicationRequest",
        "short" : "MedicationRequest Entries (USCDI Data Elements: Medications, Dose, Dose Unit of Measure, Indication)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.entry:medicationDispense",
        "path" : "Composition.section.entry",
        "sliceName" : "medicationDispense",
        "short" : "MedicationDispense Entries (USCDI Data Elements: Medications, Fill Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationdispense"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:medicationsSection.entry:medication",
        "path" : "Composition.section.entry",
        "sliceName" : "medication",
        "short" : "Medication Entries (USCDI Data Elements: Medications)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medication|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection",
        "path" : "Composition.section",
        "sliceName" : "clinicalNotesSection",
        "short" : "Clinical Notes Section",
        "definition" : "The Clinical Notes Section contains clinical notes and diagnostic reports.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection.code",
        "path" : "Composition.section.code",
        "short" : "Clinical Notes Section code",
        "definition" : "Clinical Notes Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "28650-0"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection.text",
        "path" : "Composition.section.text",
        "short" : "Clinical Notes Section narrative",
        "definition" : "Clinical Notes Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection.entry:documentReference",
        "path" : "Composition.section.entry",
        "sliceName" : "documentReference",
        "short" : "Document Reference Entries (USCDI Data Elements: Consultation Note, Discharge Summary Note, History & Physical, Imaging Narrative, Laboratory Report Narrative, Pathology Report Narrative, Procedure Note, Progress Note)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:clinicalNotesSection.entry:diagnosticReport",
        "path" : "Composition.section.entry",
        "sliceName" : "diagnosticReport",
        "short" : "Diagnostic Report Entries (USCDI Data Elements: Imaging Narrative, Laboratory Report Narrative, Pathology Report Narrative, Procedure Note)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection",
        "path" : "Composition.section",
        "sliceName" : "pregnancySection",
        "short" : "Pregnancy Section (USCDI Data Class: Health Status/Assessments - Pregnancy Status)",
        "definition" : "This section contains pregnancy data",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection.code",
        "path" : "Composition.section.code",
        "short" : "Pregnancy Section code",
        "definition" : "Pregnancy Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "90767-5"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection.text",
        "path" : "Composition.section.text",
        "short" : "Pregnancy Section narrative",
        "definition" : "Pregnancy Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection.entry:pregnancyStatusObservation",
        "path" : "Composition.section.entry",
        "sliceName" : "pregnancyStatusObservation",
        "short" : "Pregnancy Status Entries (USCDI Data Elements: Pregnancy Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancystatus"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:pregnancySection.entry:pregnancyIntent",
        "path" : "Composition.section.entry",
        "sliceName" : "pregnancyIntent",
        "short" : "Pregnancy Intent Entries (USCDI Data Elements: Pregnancy Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-pregnancyintent"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection",
        "path" : "Composition.section",
        "sliceName" : "proceduresSection",
        "short" : "Procedures Section (USCDI Data Class: Procedures)",
        "definition" : "This section describes all interventional, surgical, diagnostic, or therapeutic procedures or treatments pertinent to the patient historically at the time the document is generated. The section should include notable procedures, but can contain all procedures for the period of time being summarized.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection.code",
        "path" : "Composition.section.code",
        "short" : "Procedures Section code",
        "definition" : "Procedures Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47519-4"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection.text",
        "path" : "Composition.section.text",
        "short" : "Procedures Section narrative",
        "definition" : "Procedures Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection.entry:procedure",
        "path" : "Composition.section.entry",
        "sliceName" : "procedure",
        "short" : "Procedure Entries (USCDI Data Elements: Procedure, SDOH Interventions)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-procedure|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:proceduresSection.entry:procedureOrder",
        "path" : "Composition.section.entry",
        "sliceName" : "procedureOrder",
        "short" : "Procedure Order Entries (USCDI Data Elements: Reason for Referral, SDOH Interventions)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection",
        "path" : "Composition.section",
        "sliceName" : "resultsSection",
        "short" : "Results Section (USCDI Data Class: Laboratory, Clinical Tests)",
        "definition" : "The Results Section contains observations of results generated by laboratories, imaging procedures, and other procedures. The scope includes observations such as hematology, chemistry, serology, virology, toxicology, microbiology, plain x-ray, ultrasound, CT, MRI, angiography, echocardiography, nuclear medicine, pathology, and procedure observations. The section often includes notable results such as abnormal values or relevant trends, and could contain all results for the period of time being documented.\n\nLaboratory results are typically generated by laboratories providing analytic services in areas such as chemistry, hematology, serology, histology, cytology, anatomic pathology, microbiology, and/or virology. These observations are based on analysis of specimens obtained from the patient and submitted to the laboratory. Imaging results are typically generated by a clinician reviewing the output of an imaging procedure, such as where a cardiologist reports the left ventricular ejection fraction based on the review of a cardiac echocardiogram.\n\nProcedure results are typically generated by a clinician to provide more granular information about component observations made during a procedure, such as where a gastroenterologist reports the size of a polyp observed during a colonoscopy.\n",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection.code",
        "path" : "Composition.section.code",
        "short" : "Results Section code",
        "definition" : "Results Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30954-2"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection.text",
        "path" : "Composition.section.text",
        "short" : "Results Section narrative",
        "definition" : "Results Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection.entry:result",
        "path" : "Composition.section.entry",
        "sliceName" : "result",
        "short" : "Result Entries (USCDI Data Elements: Laboratory Tests, Laboratory Values/Results, Laboratory Specimen Type, Laboratory Result Status, Clinical Test, Clinical Test Result/Report)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:resultsSection.entry:diagnosticReport",
        "path" : "Composition.section.entry",
        "sliceName" : "diagnosticReport",
        "short" : "Diagnostic Result Entries (USCDI Data Elements: Laboratory Tests, Laboratory Values/Results, Laboratory Specimen Type, Laboratory Result Status, Clinical Test, Clinical Test Result/Report)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-lab|6.1.0",
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection",
        "path" : "Composition.section",
        "sliceName" : "socialHistorySection",
        "short" : "Social History Section (USCDI Data Class: Health Status/Assessments - Smoking Status, Patient Demographics/Information - Occupation, Occupation Industry)",
        "definition" : "This section contains social history data that influence a patient’s physical, psychological or emotional health.",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection.code",
        "path" : "Composition.section.code",
        "short" : "Social History Section code",
        "definition" : "Social History Section code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "29762-2"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection.text",
        "path" : "Composition.section.text",
        "short" : "Social History Section narrative",
        "definition" : "Social History Section narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection.entry:smokingStatus",
        "path" : "Composition.section.entry",
        "sliceName" : "smokingStatus",
        "short" : "Smoking Status Entries (USCDI Data Elements: Smoking Status)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:socialHistorySection.entry:occupation",
        "path" : "Composition.section.entry",
        "sliceName" : "occupation",
        "short" : "Occupation Entries (USCDI Data Elements: Occupation, Occupation Industry)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection",
        "path" : "Composition.section",
        "sliceName" : "vitalSignsSection",
        "short" : "Vital Signs Section (USCDI Data Class: Vital Signs)",
        "definition" : "The Vital Signs Section contains relevant vital signs for the report. The section should include notable vital signs such as the most recent, maximum and/or minimum, baseline, or relevant trends. Vital signs are represented in the same way as other results, but are aggregated into their own section to follow clinical conventions.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.code",
        "path" : "Composition.section.code",
        "short" : "Vital Signs code",
        "definition" : "Vital Signs code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.text",
        "path" : "Composition.section.text",
        "short" : "Vital Signs narrative",
        "definition" : "Vital Signs narrative",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:bloodPressure",
        "path" : "Composition.section.entry",
        "sliceName" : "bloodPressure",
        "short" : "Blood Pressure Entries (USCDI Data Elements: Systolic Blood Pressure, Diastolic Blood Pressure)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-blood-pressure|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:bodyWeight",
        "path" : "Composition.section.entry",
        "sliceName" : "bodyWeight",
        "short" : "Body Weight Entries (USCDI Data Elements: Body Weight)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-weight|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:bodyHeight",
        "path" : "Composition.section.entry",
        "sliceName" : "bodyHeight",
        "short" : "Body Height Entries (USCDI Data Elements: Body Height)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-height|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:heartRate",
        "path" : "Composition.section.entry",
        "sliceName" : "heartRate",
        "short" : "Heart Rate Entries (USCDI Data Elements: Heart Rate)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-heart-rate|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:pulseOximetry",
        "path" : "Composition.section.entry",
        "sliceName" : "pulseOximetry",
        "short" : "Pulse Oximetry Entries (USCDI Data Elements: Pulse Oximetry)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-pulse-oximetry|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:pediatricWeightForHeight",
        "path" : "Composition.section.entry",
        "sliceName" : "pediatricWeightForHeight",
        "short" : "Pediatric Weight For Height Entries (USCDI Data Elements: Pediatric Weight For Length Percentile (Birth to 36 months))",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-weight-for-height|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:pediatricHeadOccipitalFrontalCircumference",
        "path" : "Composition.section.entry",
        "sliceName" : "pediatricHeadOccipitalFrontalCircumference",
        "short" : "Pediatric Head Occipital Frontal Circumference Percentile Entries (USCDI Data Elements: Occipital Frontal Head Circumference Percentile (Birth to 36 months))",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/head-occipital-frontal-circumference-percentile|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:pediatricBMIForAge",
        "path" : "Composition.section.entry",
        "sliceName" : "pediatricBMIForAge",
        "short" : "Pediatric BMI For Age Entries (USCDI Data Elements: BMI Percentile (2-20 years old))",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/pediatric-bmi-for-age|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:bodyTemperature",
        "path" : "Composition.section.entry",
        "sliceName" : "bodyTemperature",
        "short" : "Body Temperature Entries (USCDI Data Elements: Body Temperature)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-body-temperature|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.section:vitalSignsSection.entry:respiratoryRate",
        "path" : "Composition.section.entry",
        "sliceName" : "respiratoryRate",
        "short" : "Respiratory Rate Entries (USCDI Data Elements: Respiratory Rate)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-respiratory-rate|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
