# National Health Care Surveys PlanDefinition - Health Care Surveys Reporting v2.0.0

## PlanDefinition: National Health Care Surveys PlanDefinition (Experimental) 

 
An example National Health Care Surveys PlanDefinition 

* **Actions: **: **Url: **
  * * ** :**: Route and send HCS Report: [PlanDefinition National Health Care Surveys Example](PlanDefinition-hcs-plandefinition-example.md)
* **Actions: **: **Version: **
  * * ** :**: Route and send HCS Report: 2.0.0
* **Actions: **: ** **
  * * ** :**: Route and send HCS Report:  urn:oid:2.16.840.1.113883.4.642.40.59.34.1 
* **Actions: **: **Title: **
  * * ** :**: Route and send HCS Report: PlanDefinition National Health Care Surveys Example
* **Actions: **: **Experimental: **
  * * ** :**: Route and send HCS Report: true
* **Actions: **: **Date: **
  * * ** :**: Route and send HCS Report: 2025-07-31 12:32:29-0500
* **Actions: **: **Publisher: **
  * * ** :**: Route and send HCS Report: HL7 International / Public Health
* **Actions: **: **Description: **
  * * ** :**: Route and send HCS Report: An example National Health Care Surveys PlanDefinition
* **Actions: **: **Jurisdiction: **
  * * ** :**: Route and send HCS Report: US
* **Actions: **: **Effective Period: **
  * * ** :**: Route and send HCS Report: 2025-12-01..
* **Actions: **: **Libraries: **
  * * ** :**: Route and send HCS Report: 
| |
| :--- |
| `http://example.org/fhir/Library/RuleFilters|1.0.0` |




## Resource Content

```json
{
  "resourceType" : "PlanDefinition",
  "id" : "hcs-plandefinition-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-plandefinition"
    ]
  },
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-receiver-address-extension",
      "valueReference" : {
        "reference" : "Endpoint/endpoint-pha-example"
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-receiver-jwks-url-extension",
      "valueUrl" : "http://example.org/jwks/123"
    },
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-data-encryption-algorithm-extension",
      "valueCode" : "RSA384"
    }
  ],
  "url" : "https://build.fhir.org/ig/HL7/fhir-health-care-surveys-reporting-ig/PlanDefinition/hcs-plandefinition-example",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.59.34.1"
    }
  ],
  "version" : "2.0.0",
  "name" : "PlanDefinitionNationalHealthCareSurveysExample",
  "title" : "PlanDefinition National Health Care Surveys Example",
  "type" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/plan-definition-type",
        "code" : "workflow-definition",
        "display" : "Workflow Definition"
      }
    ]
  },
  "status" : "active",
  "experimental" : true,
  "date" : "2025-07-31T12:32:29.858-05:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "An example National Health Care Surveys PlanDefinition",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "effectivePeriod" : {
    "start" : "2025-12-01"
  },
  "library" : ["http://example.org/fhir/Library/RuleFilters|1.0.0"],
  "action" : [
    {
      "id" : "start-workflow",
      "description" : "Start the workflow action.",
      "textEquivalent" : "Start the reporting workflow in response to an encounter-end event",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "initiate-reporting-workflow"
            }
          ]
        }
      ],
      "trigger" : [
        {
          "type" : "named-event",
          "name" : "encounter-end"
        }
      ],
      "relatedAction" : [
        {
          "actionId" : "check-reportability",
          "relationship" : "before-start"
        }
      ]
    },
    {
      "id" : "check-reportability",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      ],
      "action" : [
        {
          "id" : "is-ambulatory-encounter-reportable",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "evaluate-condition"
                }
              ]
            }
          ]
        },
        {
          "id" : "is-inpatient-encounter-reportable",
          "code" : [
            {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
                  "code" : "evaluate-condition"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "id" : "create-hcs-report",
      "code" : [
        {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "create-report"
            }
          ]
        }
      ]
    },
    {
      "id" : "validate-hcs-report"
    },
    {
      "id" : "submit-hcs-report",
      "textEquivalent" : "Route and send HCS Report"
    }
  ]
}

```
