# Patient - Dominique Ledner - Health Care Surveys Reporting v2.0.0

## Example Patient: Patient - Dominique Ledner

Language: en

Profile: [US Core Patient Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)

Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))

-------

| | | | |
| :--- | :--- | :--- | :--- |
| Deceased: | false | Marital Status: | Legally married |
| Other Ids: | * [California Driver's License](http://terminology.hl7.org/5.5.0/NamingSystem-CaliforniaDLN.html)/patient-LednerDominique
* SHID/12446 (use: usual, )
* FHIR/66574567 (use: usual, )
 | | |
| Contact Detail | * ph: 1-(303)555-1212(Home)
* [dominique.ledner@example.com](mailto:dominique.ledner@example.com)
* 25 Church St Bixby OK 74008 USA (home)
 | | |
| Language: | English(preferred) | | |
| Links: | * General Practitioner: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)
* Managing Organization: [Healthcare Example](Organization-organization-healthcare.md)
 | | |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "patient-ledner",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.4.3.6",
      "value" : "patient-LednerDominique"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "SHID"
      },
      "system" : "http://example.org/hospital.smarthealth",
      "value" : "12446"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "FHIR"
      },
      "system" : "http://example.com/FHIR/StructureDefinition/patient-fhir-id",
      "value" : "66574567"
    },
    {
      "use" : "usual",
      "type" : {
        "text" : "MRN"
      },
      "system" : "urn:oid:2.16.840.1.113883.4.3.2",
      "value" : "abc123"
    }
  ],
  "name" : [
    {
      "family" : "Ledner",
      "given" : ["Dominique"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "1-(303)555-1212",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "dominique.ledner@example.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1965-06-22",
  "deceasedBoolean" : false,
  "address" : [
    {
      "use" : "home",
      "line" : ["25 Church St"],
      "city" : "Bixby",
      "state" : "OK",
      "postalCode" : "74008",
      "country" : "USA"
    }
  ],
  "maritalStatus" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "36629006",
        "display" : "Legally married"
      },
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
        "code" : "M"
      }
    ]
  },
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en",
            "display" : "English"
          }
        ]
      },
      "preferred" : true
    }
  ],
  "generalPractitioner" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "managingOrganization" : {
    "reference" : "Organization/organization-healthcare",
    "display" : "Healthcare Example"
  }
}

```
