# Patient - Amy Baxter - Health Care Surveys Reporting v2.0.0

## Example Patient: Patient - Amy Baxter

Language: en

Profile: [US Core Patient Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-patient.html)

Amy V. Shaw Female, DoB: 1987-02-20 ( Medical Record Number: 1032702 (use: usual, ))

-------

| | |
| :--- | :--- |
| Active: | true |
| Alt. Name: | Amy V. Baxter |
| Contact Detail | * ph: 555-555-5555(Home)
* [amy.shaw@example.com](mailto:amy.shaw@example.com)
* 49 Meadow St Mounds OK 74047 US 
* 183 Mountain View St Mounds OK 74048 US 
 |
| [US Core Birth Sex Extension](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-birthsex.html) | F |
| US Core Tribal Affiliation Extension: | * tribalAffiliation: Fort Mojave Indian Tribe of Arizona, California & Nevada
* isEnrolled: true
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "patient-baxter",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-birthsex",
      "valueCode" : "F"
    },
    {
      "extension" : [
        {
          "url" : "tribalAffiliation",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-TribalEntityUS",
                "code" : "91",
                "display" : "Fort Mojave Indian Tribe of Arizona, California & Nevada"
              }
            ]
          }
        },
        {
          "url" : "isEnrolled",
          "valueBoolean" : true
        }
      ],
      "url" : "http://hl7.org/fhir/us/core/StructureDefinition/us-core-tribal-affiliation"
    }
  ],
  "identifier" : [
    {
      "use" : "usual",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MR",
            "display" : "Medical Record Number"
          }
        ],
        "text" : "Medical Record Number"
      },
      "system" : "http://example.org/hospital.smarthealth",
      "value" : "1032702"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Shaw",
      "given" : ["Amy", "V."],
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "family" : "Baxter",
      "given" : ["Amy", "V."],
      "suffix" : ["PharmD"],
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "home"
    },
    {
      "system" : "email",
      "value" : "amy.shaw@example.com"
    }
  ],
  "gender" : "female",
  "birthDate" : "1987-02-20",
  "address" : [
    {
      "line" : ["49 Meadow St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74047",
      "country" : "US",
      "period" : {
        "start" : "2016-12-06",
        "end" : "2020-07-22"
      }
    },
    {
      "line" : ["183 Mountain View St"],
      "city" : "Mounds",
      "state" : "OK",
      "postalCode" : "74048",
      "country" : "US",
      "period" : {
        "start" : "2020-07-22"
      }
    }
  ]
}

```
