# Payer Organization Example - UPMC - Health Care Surveys Reporting v2.0.0

## Example Organization: Payer Organization Example - UPMC

Language: en

Profile: [US Core Organization Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**identifier**: [National Association of Insurance Commissioners (NAIC) Company Codes](http://terminology.hl7.org/7.0.1/NamingSystem-NAICCompanyCodes.html)/95216

**active**: true

**name**: UPMC Health Plan

**telecom**: ph: 1-844-220-4785 TTY: 711(Work), ph: 1-866-406-8762(Work)

**address**: UPMC Health Plan Attn: Commercial Plans U.S. Steel Tower 600 Grant Street Pittsburgh PA 15219 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "organization-payer-upmc",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "urn:oid:2.16.840.1.113883.6.300",
      "value" : "95216"
    }
  ],
  "active" : true,
  "name" : "UPMC Health Plan",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "1-844-220-4785 TTY: 711",
      "use" : "work"
    },
    {
      "system" : "phone",
      "value" : "1-866-406-8762",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "type" : "physical",
      "line" : [
        "UPMC Health Plan",
        "Attn: Commercial Plans",
        "U.S. Steel Tower",
        "600 Grant Street"
      ],
      "city" : "Pittsburgh",
      "state" : "PA",
      "postalCode" : "15219"
    }
  ]
}

```
