# Payer Organization Example - Blue Cross Blue Shield - Health Care Surveys Reporting v2.0.0

## Example Organization: Payer Organization Example - Blue Cross Blue Shield

Language: en

Profile: [US Core Organization Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1234567893

**active**: true

**type**: Payer

**name**: Blue Cross Blue Shield

**telecom**: ph: 800-555-1234(Work), [contact@bcbs.example.com](mailto:contact@bcbs.example.com)

**address**: 456 Insurance Ave Anytown CA 12345 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "organization-payer-bcbs",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    }
  ],
  "active" : true,
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
          "code" : "pay",
          "display" : "Payer"
        }
      ]
    }
  ],
  "name" : "Blue Cross Blue Shield",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "800-555-1234",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "contact@bcbs.example.com",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["456 Insurance Ave"],
      "city" : "Anytown",
      "state" : "CA",
      "postalCode" : "12345",
      "country" : "US"
    }
  ]
}

```
