# Observation - Occupation and Industry - Health Care Surveys Reporting v2.0.0

## Example Observation: Observation - Occupation and Industry

Language: en

Profile: [US Core Observation Occupation Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-occupation.html)

**status**: Final

**category**: Social History

**code**: History of Occupation

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md)

**effective**: 2025-01-02 09:30:00+0000 --> (ongoing)

**performer**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**value**: Certified Nursing Assistant (CNA) [Nursing Assistants]

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | History of Occupation Industry | Home nursing services |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-occupation-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-occupation|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11341-5",
        "display" : "History of Occupation"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "effectivePeriod" : {
    "start" : "2025-01-02T09:30:00Z"
  },
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH",
        "code" : "31-1014.00.007136",
        "display" : "Certified Nursing Assistant (CNA) [Nursing Assistants]"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "86188-0",
            "display" : "History of Occupation Industry"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/PHOccupationalDataForHealthODH",
            "code" : "621610.008495",
            "display" : "Home nursing services"
          }
        ]
      }
    }
  ]
}

```
