# Observation - Leukocytes Laboratory Result - Health Care Surveys Reporting v2.0.0

## Example Observation: Observation - Leukocytes Laboratory Result

Language: en

Profile: [US Core Laboratory Result Observation Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-lab.html)

**status**: Final

**category**: Laboratory

**code**: Leukocytes [#/volume] in Blood

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Ambulatory Office Visit](Encounter-encounter-ambulatory.md)

**effective**: 2025-01-02

**issued**: 2025-01-02 10:30:00+0000

**performer**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**value**: 6.8 10^3/uL (Details: UCUM code10^3/uL = '10^3/uL')

**interpretation**: Normal



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-lab-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-lab|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory",
          "display" : "Laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "26464-8",
        "display" : "Leukocytes [#/volume] in Blood"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory",
    "display" : "Ambulatory Office Visit"
  },
  "effectiveDateTime" : "2025-01-02",
  "issued" : "2025-01-02T10:30:00Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "valueQuantity" : {
    "value" : 6.8,
    "unit" : "10^3/uL",
    "system" : "http://unitsofmeasure.org",
    "code" : "10^3/uL"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "N",
          "display" : "Normal"
        }
      ]
    }
  ]
}

```
