# MessageHeader - Healthcare Survey Report Header - Health Care Surveys Reporting v2.0.0

## Example MessageHeader: MessageHeader - Healthcare Survey Report Header

Language: en

Profile: [US Public Health MessageHeader](http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-messageheader.html)

**US Public Health Data Encrypted Extension**: false

**US Public Health Initiation Type Extension**: Indicates a report was initiation based on a Subscription Notification.

**US Public Health Message Processing Category Extension**: notification

**event**: [US Public Health CodeSystem - Message Types: healthcare-survey-report-message](http://hl7.org/fhir/us/ph-library/STU1/CodeSystem-us-ph-codesystem-message-types.html#us-ph-codesystem-message-types-healthcare-survey-report-message) (Indicates a message containing healthcare survey data sent from clinical care to PHA.)

### Destinations

| | | |
| :--- | :--- | :--- |
| - | **Name** | **Endpoint** |
| * | PHA endpoint | [http://example.org/pha-fhir](http://example.org/pha-fhir) |

**sender**: [Organization Example Healthcare Organization](Bundle-healthcare-surveys-reporting-bundle.md#http-//example.org/fhir/Organization/organization-healthcare)

### Sources

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| - | **Name** | **Software** | **Version** | **Contact** | **Endpoint** |
| * | Healthcare Organization | Backend Service App | 3.1.45.AABB | [+1 (917) 123 4567](tel:+1(917)1234567) | [http://example.org/healthcare.org/fhir](http://example.org/healthcare.org/fhir) |

**reason**: Indicates the close of an encounter



## Resource Content

```json
{
  "resourceType" : "MessageHeader",
  "id" : "messageheader-example-reportheader",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-messageheader"
    ]
  },
  "language" : "en",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-data-encrypted-extension",
      "valueBoolean" : false
    },
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-report-initiation-type-extension",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-report-initiation-types",
            "code" : "subscription-notification"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-message-processing-category-extension",
      "valueCode" : "notification"
    }
  ],
  "eventCoding" : {
    "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-message-types",
    "code" : "healthcare-survey-report-message"
  },
  "destination" : [
    {
      "name" : "PHA endpoint",
      "endpoint" : "http://example.org/pha-fhir"
    }
  ],
  "sender" : {
    "reference" : "http://example.org/fhir/Organization/organization-healthcare"
  },
  "source" : {
    "name" : "Healthcare Organization",
    "software" : "Backend Service App",
    "version" : "3.1.45.AABB",
    "contact" : {
      "system" : "phone",
      "value" : "+1 (917) 123 4567"
    },
    "endpoint" : "http://example.org/healthcare.org/fhir"
  },
  "reason" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents",
        "code" : "encounter-close"
      }
    ]
  }
}

```
