# MedicationAdministration - Lantus Subcutaneous - Health Care Surveys Reporting v2.0.0

## Example MedicationAdministration: MedicationAdministration - Lantus Subcutaneous

Language: en

Profile: [Health Care Surveys Medication Administration](StructureDefinition-hcs-medicationadministration.md)

**status**: Completed

**medication**: Lantus 100 UNT/ML Injectable Solution

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**effective**: 2015-01-15 04:30:00+0100 --> 2015-01-15 14:30:00+0100

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md) |

### Dosages

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Text** | **Route** | **Dose** |
| * | 20 Units SC before breakfast | Subcutaneous (qualifier value) | 20 U (Details: UCUM codeU = 'U') |



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "medicationadministration-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-medicationadministration"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "285018",
        "display" : "Lantus 100 UNT/ML Injectable Solution"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "effectivePeriod" : {
    "start" : "2015-01-15T04:30:00+01:00",
    "end" : "2015-01-15T14:30:00+01:00"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/practitioner-nichols"
      }
    }
  ],
  "dosage" : {
    "text" : "20 Units SC before breakfast",
    "route" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "263887005",
          "display" : "Subcutaneous (qualifier value)"
        }
      ]
    },
    "dose" : {
      "value" : 20,
      "unit" : "U",
      "system" : "http://unitsofmeasure.org",
      "code" : "U"
    }
  }
}

```
