# Goal - Resolution of Acute Bronchitis - Health Care Surveys Reporting v2.0.0

## Example Goal: Goal - Resolution of Acute Bronchitis

Language: en

Profile: [US Core Goal Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-goal.html)

**lifecycleStatus**: Active

**achievementStatus**: In Progress

**description**: Resolve acute bronchitis within 2 weeks

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**start**: 2025-01-02

### Targets

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Measure** | **Detail[x]** | **Due[x]** |
| * | Chronic kidney disease stage 1 (disorder) | Resolution of cough and other symptoms | 2025-01-16 |

**statusDate**: 2025-01-02

**statusReason**: Treatment initiated

**expressedBy**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**addresses**: [Condition Acute bronchitis (disorder)](Condition-condition-encounter-diagnosis-example.md)

**note**: @2025-01-02 10:30:00+0000

> 

Patient understands the plan and is committed to improved rest and hydration




## Resource Content

```json
{
  "resourceType" : "Goal",
  "id" : "goal-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-goal|6.1.0"
    ]
  },
  "language" : "en",
  "lifecycleStatus" : "active",
  "achievementStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/goal-achievement",
        "code" : "in-progress"
      }
    ]
  },
  "description" : {
    "text" : "Resolve acute bronchitis within 2 weeks"
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "startDate" : "2025-01-02",
  "target" : [
    {
      "measure" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "431855005",
            "display" : "Chronic kidney disease stage 1 (disorder)"
          }
        ]
      },
      "detailString" : "Resolution of cough and other symptoms",
      "dueDate" : "2025-01-16"
    }
  ],
  "statusDate" : "2025-01-02",
  "statusReason" : "Treatment initiated",
  "expressedBy" : {
    "reference" : "Patient/patient-ledner"
  },
  "addresses" : [
    {
      "reference" : "Condition/condition-encounter-diagnosis-example"
    }
  ],
  "note" : [
    {
      "time" : "2025-01-02T10:30:00Z",
      "text" : "Patient understands the plan and is committed to improved rest and hydration"
    }
  ]
}

```
