# Endpoint - Public Health Agency FHIR Server - Health Care Surveys Reporting v2.0.0

## Example Endpoint: Endpoint - Public Health Agency FHIR Server

Language: en

Profile: [US Public Health Endpoint](http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-endpoint.html)

**identifier**: `http://example.org/pha/enpoint-identifier`/endpoint-pha-id

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: PHAReceiver

**managingOrganization**: [Organization Example PHA Organization](Organization-organization-pha.md)

**contact**: [endpointmanager@example.pha.org](mailto:endpointmanager@example.pha.org)

**period**: 2020-11-20 --> (ongoing)

**payloadType**: Bundle

**payloadMimeType**: application/fhir+xml, application/fhir+json

**address**: [http://example.org/pha-fhir](http://example.org/pha-fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "endpoint-pha-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-endpoint"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://example.org/pha/enpoint-identifier",
      "value" : "endpoint-pha-id"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "PHAReceiver",
  "managingOrganization" : {
    "reference" : "Organization/organization-pha"
  },
  "contact" : [
    {
      "system" : "email",
      "value" : "endpointmanager@example.pha.org",
      "use" : "work"
    }
  ],
  "period" : {
    "start" : "2020-11-20"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/resource-types",
          "code" : "Bundle"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+xml", "application/fhir+json"],
  "address" : "http://example.org/pha-fhir"
}

```
