# DiagnosticReport - Chest X-ray Radiology Note - Health Care Surveys Reporting v2.0.0

## Example DiagnosticReport: DiagnosticReport - Chest X-ray Radiology Note

Language: en

Profile: [US Core DiagnosticReport Profile for Report and Note Exchangeversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-diagnosticreport-note.html)

## XR Chest PA and Lateral (Radiology ) 

| | |
| :--- | :--- |
| Subject | Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, )) |
| When For | 2025-01-02 10:00:00+0000 |
| Reported | 2025-01-02 11:30:00+0000 |
| Performer | [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md) |

**Report Details**

* **Code**: [Radiology Study observation (narrative)](Observation-observation-clinical-result-xray-example.md)
  * **Value**: LINES AND TUBES: None. LUNGS AND PLEURA: Clear lungs. Normal pulmonary vascularity. No pleural effusion. No pneumothorax. HEART, MEDIASTINUM AND HILA: Heart is normal in size. Normal mediastinal and hilar contour. BONES AND SOFT TISSUES: No acute abnormality.
  * **Flags**: Final
  * **When For**: 2025-01-02
  * **Reported**: 2025-01-02 10:30:00+0000

No acute radiographic abnormality



## Resource Content

```json
{
  "resourceType" : "DiagnosticReport",
  "id" : "diagnosticreport-note-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-diagnosticreport-note|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "LP29684-5",
          "display" : "Radiology"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "42272-5",
        "display" : "XR Chest PA and Lateral"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "effectiveDateTime" : "2025-01-02T10:00:00Z",
  "issued" : "2025-01-02T11:30:00Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "result" : [
    {
      "reference" : "Observation/observation-clinical-result-xray-example"
    }
  ],
  "conclusion" : "No acute radiographic abnormality"
}

```
