# Coverage - UPMC Health Plan - Health Care Surveys Reporting v2.0.0

## Example Coverage: Coverage - UPMC Health Plan

Language: en

Profile: [US Core Coverage Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-coverage.html)

**identifier**: An identifier for the insured of an insurance policy (this insured always has a subscriber), usually assigned by the insurance carrier./88800933501

**status**: Active

**policyHolder**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**subscriber**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**subscriberId**: 888009335

**beneficiary**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**dependent**: 01

**relationship**: Self

**period**: 2020-01-01 --> (ongoing)

**payor**: [UPMC Health Plan](Organization-organization-payer-upmc.md)

> **class****type**: An employee group**value**: MCHMO1**name**: MEDICARE HMO PLAN

> **class****type**: A specific suite of benefits.**value**: GR5**name**: GR5-HMO DEDUCTIBLE

**network**: GR5-HMO DEDUCTIBLE



## Resource Content

```json
{
  "resourceType" : "Coverage",
  "id" : "coverage-upmc-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-coverage|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "MB",
            "display" : "Member Number"
          }
        ],
        "text" : "An identifier for the insured of an insurance policy (this insured always has a subscriber), usually assigned by the insurance carrier."
      },
      "system" : "https://www.example.org/upmchealthplan.com/fhir/memberidentifier",
      "value" : "88800933501",
      "assigner" : {
        "reference" : "Organization/organization-payer-upmc",
        "display" : "UPMC Health Plan"
      }
    }
  ],
  "status" : "active",
  "policyHolder" : {
    "reference" : "Patient/patient-ledner"
  },
  "subscriber" : {
    "reference" : "Patient/patient-ledner"
  },
  "subscriberId" : "888009335",
  "beneficiary" : {
    "reference" : "Patient/patient-ledner"
  },
  "dependent" : "01",
  "relationship" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/subscriber-relationship",
        "code" : "self"
      }
    ],
    "text" : "Self"
  },
  "period" : {
    "start" : "2020-01-01"
  },
  "payor" : [
    {
      "reference" : "Organization/organization-payer-upmc",
      "display" : "UPMC Health Plan"
    }
  ],
  "class" : [
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "group",
            "display" : "Group"
          }
        ],
        "text" : "An employee group"
      },
      "value" : "MCHMO1",
      "name" : "MEDICARE HMO PLAN"
    },
    {
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/coverage-class",
            "code" : "plan",
            "display" : "Plan"
          }
        ],
        "text" : "A specific suite of benefits."
      },
      "value" : "GR5",
      "name" : "GR5-HMO DEDUCTIBLE"
    }
  ],
  "network" : "GR5-HMO DEDUCTIBLE"
}

```
