# Condition - Acute Viral Pharyngitis - Health Care Surveys Reporting v2.0.0

## Example Condition: Condition - Acute Viral Pharyngitis

Language: en

Profile: [US Core Condition Problems and Health Concerns Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-condition-problems-health-concerns.html)

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**category**: Problem List Item

**code**: Acute viral pharyngitis

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**onset**: 2025-01-01

**recordedDate**: 2025-01-02

**recorder**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)



## Resource Content

```json
{
  "resourceType" : "Condition",
  "id" : "condition-problem-pharyngitis-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-condition-problems-health-concerns|6.1.0"
    ]
  },
  "language" : "en",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
        "code" : "confirmed"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/condition-category",
          "code" : "problem-list-item"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "195662009",
        "display" : "Acute viral pharyngitis"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "onsetDateTime" : "2025-01-01",
  "recordedDate" : "2025-01-02",
  "recorder" : {
    "reference" : "Practitioner/practitioner-nichols"
  }
}

```
