# CareTeam - Respiratory Care Team - Health Care Surveys Reporting v2.0.0

## Example CareTeam: CareTeam - Respiratory Care Team

Language: en

Profile: [US Core CareTeam Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-careteam.html)

**status**: Active

**name**: Respiratory Care Team

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md)

**period**: 2025-01-02 --> (ongoing)

> **participant****role**: Primary care physician (occupation)**member**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)**onBehalfOf**: [Organization General Hospital](Organization-organization-example.md)**period**: 2025-01-02 --> (ongoing)

> **participant****role**: Physician**member**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)**onBehalfOf**: [Organization General Hospital](Organization-organization-example.md)**period**: 2025-01-02 --> (ongoing)



## Resource Content

```json
{
  "resourceType" : "CareTeam",
  "id" : "careteam-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-careteam|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "active",
  "name" : "Respiratory Care Team",
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "period" : {
    "start" : "2025-01-02"
  },
  "participant" : [
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "446050000",
              "display" : "Primary care physician (occupation)"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/practitioner-nichols"
      },
      "onBehalfOf" : {
        "reference" : "Organization/organization-example"
      },
      "period" : {
        "start" : "2025-01-02"
      }
    },
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "309343006",
              "display" : "Physician"
            }
          ]
        }
      ],
      "member" : {
        "reference" : "Practitioner/practitioner-nichols"
      },
      "onBehalfOf" : {
        "reference" : "Organization/organization-example"
      },
      "period" : {
        "start" : "2025-01-02"
      }
    }
  ]
}

```
