# Health Care Surveys EHR Capability Statement - Health Care Surveys Reporting v2.0.0

## CapabilityStatement: Health Care Surveys EHR Capability Statement 

 
This profile defines the expected capabilities of the ''EHR'' actor when conforming to the Health Care Surveys Content Implementation Guide. This role is responsible for allowing creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs. 

 [Raw OpenAPI-Swagger Definition file](../health-care-surveys-reporting-data-source.openapi.json) | [Download](../health-care-surveys-reporting-data-source.openapi.json) 



## Resource Content

```json
{
  "resourceType" : "CapabilityStatement",
  "id" : "health-care-surveys-reporting-data-source",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/health-care-surveys-reporting/CapabilityStatement/health-care-surveys-reporting-data-source",
  "version" : "2.0.0",
  "name" : "HealthcareSurveysReportingEHRCapabilityStatement",
  "title" : "Health Care Surveys EHR Capability Statement",
  "status" : "active",
  "date" : "2020-12-06",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This profile defines the expected capabilities of the ''EHR'' actor when conforming to the Health Care Surveys Content Implementation Guide.     This role is responsible for allowing creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "kind" : "requirements",
  "fhirVersion" : "4.0.1",
  "format" : ["json"],
  "rest" : [
    {
      "mode" : "server",
      "documentation" : "The focus of the EHR is to allow creation, modification and deletion of Subscriptions and allows searching and retrieval of resources using US Core APIs. ",
      "security" : {
        "description" : "Implementations must meet the general security requirements documented in the security section of the implementation guide."
      },
      "resource" : [
        {
          "type" : "Subscription",
          "interaction" : [
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "read",
              "documentation" : "Allows retrieval of a specific Subscription instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "create",
              "documentation" : "Allows creation of a Subscription resource instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "update",
              "documentation" : "Allows update of a Subscription resource instance."
            },
            {
              "extension" : [
                {
                  "url" : "http://hl7.org/fhir/StructureDefinition/capabilitystatement-expectation",
                  "valueCode" : "SHALL"
                }
              ],
              "code" : "delete",
              "documentation" : "Allows deletion of a Subscription resource instance."
            }
          ]
        }
      ]
    }
  ]
}

```
