# Bundle - Healthcare Surveys Reporting Message - Health Care Surveys Reporting v2.0.0

## Example Bundle: Bundle - Healthcare Surveys Reporting Message



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "healthcare-surveys-reporting-bundle",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-reporting-bundle"
    ]
  },
  "language" : "en",
  "type" : "message",
  "timestamp" : "2020-11-20T11:15:33-10:00",
  "entry" : [
    {
      "fullUrl" : "http://example.org/fhir/MessageHeader/messageheader-example-reportheader",
      "resource" : {
        "resourceType" : "MessageHeader",
        "id" : "messageheader-example-reportheader",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-messageheader"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MessageHeader_messageheader-example-reportheader\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MessageHeader messageheader-example-reportheader</b></p><a name=\"messageheader-example-reportheader\"> </a><a name=\"hcmessageheader-example-reportheader\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-messageheader.html\">US Public Health MessageHeader</a></p></div><p><b>US Public Health Data Encrypted Extension</b>: false</p><p><b>US Public Health Initiation Type Extension</b>: <span title=\"Codes:{http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-report-initiation-types subscription-notification}\">Indicates a report was initiation based on a Subscription Notification.</span></p><p><b>US Public Health Message Processing Category Extension</b>: notification</p><p><b>event</b>: <a href=\"http://hl7.org/fhir/us/ph-library/STU1/CodeSystem-us-ph-codesystem-message-types.html#us-ph-codesystem-message-types-healthcare-survey-report-message\">US Public Health CodeSystem - Message Types: healthcare-survey-report-message</a> (Indicates a message containing healthcare survey data sent from clinical care to PHA.)</p><h3>Destinations</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Endpoint</b></td></tr><tr><td style=\"display: none\">*</td><td>PHA endpoint</td><td><a href=\"http://example.org/pha-fhir\">http://example.org/pha-fhir</a></td></tr></table><p><b>sender</b>: <a href=\"Organization-organization-healthcare.html\">Organization Example Healthcare Organization</a></p><h3>Sources</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Name</b></td><td><b>Software</b></td><td><b>Version</b></td><td><b>Contact</b></td><td><b>Endpoint</b></td></tr><tr><td style=\"display: none\">*</td><td>Healthcare Organization</td><td>Backend Service App</td><td>3.1.45.AABB</td><td><a href=\"tel:+1(917)1234567\">+1 (917) 123 4567</a></td><td><a href=\"http://example.org/healthcare.org/fhir\">http://example.org/healthcare.org/fhir</a></td></tr></table><p><b>reason</b>: <span title=\"Codes:{http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents encounter-close}\">Indicates the close of an encounter</span></p><p><b>focus</b>: <a href=\"Bundle-healthcare-surveys-reporting-bundle.html#http-//example.org/fhir/Bundle/healthcare-surveys-content-bundle\">Bundle: type = collection; timestamp = 2020-11-20 11:15:33-1000</a></p></div>"
        },
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-data-encrypted-extension",
            "valueBoolean" : false
          },
          {
            "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-report-initiation-type-extension",
            "valueCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-report-initiation-types",
                  "code" : "subscription-notification"
                }
              ]
            }
          },
          {
            "url" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-message-processing-category-extension",
            "valueCode" : "notification"
          }
        ],
        "eventCoding" : {
          "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-message-types",
          "code" : "healthcare-survey-report-message"
        },
        "destination" : [
          {
            "name" : "PHA endpoint",
            "endpoint" : "http://example.org/pha-fhir"
          }
        ],
        "sender" : {
          "reference" : "Organization/organization-healthcare"
        },
        "source" : {
          "name" : "Healthcare Organization",
          "software" : "Backend Service App",
          "version" : "3.1.45.AABB",
          "contact" : {
            "system" : "phone",
            "value" : "+1 (917) 123 4567"
          },
          "endpoint" : "http://example.org/healthcare.org/fhir"
        },
        "reason" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-triggerdefinition-namedevents",
              "code" : "encounter-close"
            }
          ]
        },
        "focus" : [
          {
            "reference" : "http://example.org/fhir/Bundle/healthcare-surveys-content-bundle"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Bundle/healthcare-surveys-content-bundle",
      "resource" : {
        "resourceType" : "Bundle",
        "id" : "healthcare-surveys-content-bundle",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-content-bundle"
          ]
        },
        "type" : "collection",
        "timestamp" : "2020-11-20T11:15:33-10:00",
        "entry" : [
          {
            "fullUrl" : "http://example.org/fhir/Composition/rep-composition-content-example",
            "resource" : {
              "resourceType" : "Composition",
              "id" : "rep-composition-content-example",
              "meta" : {
                "profile" : [
                  "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-composition"
                ]
              },
              "text" : {
                "status" : "extensions",
                "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p><b>Amy Shaw data for HCS</b></p></div>"
              },
              "identifier" : {
                "value" : "c03eab8c-11e8-4d0c-ad2a-b385395e27db"
              },
              "status" : "final",
              "type" : {
                "coding" : [
                  {
                    "system" : "http://loinc.org",
                    "code" : "75619-7"
                  }
                ]
              },
              "subject" : {
                "reference" : "Patient/patient-ledner",
                "display" : "Amy Shaw"
              },
              "encounter" : {
                "reference" : "Encounter/encounter-ambulatory",
                "display" : "Ambulatory Office Visit"
              },
              "date" : "2023-01-02T22:13:23Z",
              "author" : [
                {
                  "reference" : "Practitioner/practitioner-nichols",
                  "display" : "Nicholas Joseph"
                }
              ],
              "title" : "National Health Care Surveys report",
              "section" : [
                {
                  "title" : "Reason for Visit Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "29299-5",
                        "display" : "Reason for visit Narrative"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Reason for Visit: Bad cough</p></div>"
                  }
                },
                {
                  "title" : "Problems Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "11450-4",
                        "display" : "Problem list - Reported"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Single liveborn, born in hospital</p></div>"
                  },
                  "entry" : [
                    {
                      "reference" : "Condition/condition-problem-liveborn-example"
                    }
                  ]
                },
                {
                  "title" : "Allergies Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "48765-2",
                        "display" : "Allergies and adverse reactions Document"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><p>Allergy to Sulfonide</p></div>"
                  },
                  "entry" : [
                    {
                      "reference" : "AllergyIntolerance/allergyintolerance-sulfonamide-example"
                    }
                  ]
                },
                {
                  "title" : "Medications Section",
                  "code" : {
                    "coding" : [
                      {
                        "system" : "http://loinc.org",
                        "code" : "10160-0",
                        "display" : "History of Medication use Narrative"
                      }
                    ]
                  },
                  "text" : {
                    "status" : "generated",
                    "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\">Taking Lantus</div>"
                  },
                  "entry" : [
                    {
                      "reference" : "MedicationAdministration/medicationadministration-example"
                    }
                  ]
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Organization/organization-healthcare",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "organization-healthcare",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-organization"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_organization-healthcare\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Organization organization-healthcare</b></p><a name=\"organization-healthcare\"> </a><a name=\"hcorganization-healthcare\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-organization.html\">US Public Health Organization</a></p></div><p><b>active</b>: true</p><p><b>name</b>: Example Healthcare Organization</p><p><b>telecom</b>: ph: (917)932-2000(Work)</p><p><b>address</b>: 3300 Mayland Avenue, Suite 227 Altanta GA</p><p><b>endpoint</b>: <a href=\"Endpoint-endpoint-healthcare-example.html\">Endpoint HealthCareSenderAndReceiver</a></p></div>"
        },
        "active" : true,
        "name" : "Example Healthcare Organization",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "(917)932-2000",
            "use" : "work"
          }
        ],
        "address" : [
          {
            "text" : "3300 Mayland Avenue, Suite 227 Altanta GA",
            "line" : ["4401 Peach Rd,"],
            "city" : "Atlanta",
            "state" : "GA",
            "postalCode" : "81452"
          }
        ],
        "endpoint" : [
          {
            "reference" : "Endpoint/endpoint-healthcare-example"
          }
        ]
      }
    },
    {
      "fullUrl" : "http://example.org/fhir/Endpoint/endpoint-healthcare-example",
      "resource" : {
        "resourceType" : "Endpoint",
        "id" : "endpoint-healthcare-example",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-endpoint"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Endpoint_endpoint-healthcare-example\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Endpoint endpoint-healthcare-example</b></p><a name=\"endpoint-healthcare-example\"> </a><a name=\"hcendpoint-healthcare-example\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-endpoint.html\">US Public Health Endpoint</a></p></div><p><b>identifier</b>: <code>http://example.org/healthcare.org/enpoint-identifier</code>/endpoint-healthcare-example-id</p><p><b>status</b>: Active</p><p><b>connectionType</b>: <a href=\"http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest\">Endpoint Connection Type: hl7-fhir-rest</a> (HL7 FHIR)</p><p><b>name</b>: HealthCareSenderAndReceiver</p><p><b>managingOrganization</b>: <a href=\"Organization-organization-healthcare.html\">Organization Example Healthcare Organization</a></p><p><b>contact</b>: <a href=\"mailto:endpointmanager@example.healthcare.org\">endpointmanager@example.healthcare.org</a></p><p><b>period</b>: 2020-11-20 --&gt; (ongoing)</p><p><b>payloadType</b>: <span title=\"Codes:{http://hl7.org/fhir/resource-types Bundle}\">Bundle</span></p><p><b>payloadMimeType</b>: application/fhir+xml, application/fhir+json</p><p><b>address</b>: <a href=\"http://example.org/healthcare.org/fhir\">http://example.org/healthcare.org/fhir</a></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://example.org/healthcare.org/enpoint-identifier",
            "value" : "endpoint-healthcare-example-id"
          }
        ],
        "status" : "active",
        "connectionType" : {
          "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
          "code" : "hl7-fhir-rest"
        },
        "name" : "HealthCareSenderAndReceiver",
        "managingOrganization" : {
          "reference" : "Organization/organization-healthcare"
        },
        "contact" : [
          {
            "system" : "email",
            "value" : "endpointmanager@example.healthcare.org",
            "use" : "work"
          }
        ],
        "period" : {
          "start" : "2020-11-20"
        },
        "payloadType" : [
          {
            "coding" : [
              {
                "system" : "http://hl7.org/fhir/resource-types",
                "code" : "Bundle"
              }
            ]
          }
        ],
        "payloadMimeType" : ["application/fhir+xml", "application/fhir+json"],
        "address" : "http://example.org/healthcare.org/fhir"
      }
    }
  ]
}

```
