# hl7.fhir.us.health-care-surveys-reporting#2.0.0: Health Care Surveys Reporting(en)

## Pages

* [Home](index.md)
* [Change Log](changelog.md)
* [Downloads](downloads.md)
* [Background](background.md)
* [Artifacts Summary](artifacts.md)
* [Specification](specification.md)

## Resources

### Resource Profiles

* [Health Care Surveys Composition](StructureDefinition-hcs-composition.md)
* [Health Care Surveys Content Bundle](StructureDefinition-hcs-content-bundle.md)
* [Health Care Surveys Medication Administration](StructureDefinition-hcs-medicationadministration.md)
* [Health Care Surveys PlanDefinition](StructureDefinition-hcs-plandefinition.md)
* [Health Care Surveys Reporting Bundle](StructureDefinition-hcs-reporting-bundle.md)

### CapabilityStatements

* [Health Care Surveys EHR Capability Statement](CapabilityStatement-health-care-surveys-reporting-data-source.md)

### ImplementationGuides

* [Health Care Surveys Reporting](ImplementationGuide-hl7.fhir.us.health-care-surveys-reporting.md)

### Examples

* [allergyintolerance-sulfonamide-example (AllergyIntolerance)](AllergyIntolerance-allergyintolerance-sulfonamide-example.md)
* [hcs-content-bundle-example (Bundle)](Bundle-hcs-content-bundle-example.md)
* [healthcare-surveys-reporting-bundle (Bundle)](Bundle-healthcare-surveys-reporting-bundle.md)
* [Respiratory Care Team (CareTeam)](CareTeam-careteam-example.md)
* [National Health Care Surveys report (Composition)](Composition-hcs-composition-example.md)
* [condition-encounter-diagnosis-example (Condition)](Condition-condition-encounter-diagnosis-example.md)
* [condition-problem-liveborn-example (Condition)](Condition-condition-problem-liveborn-example.md)
* [condition-problem-pharyngitis-example (Condition)](Condition-condition-problem-pharyngitis-example.md)
* [coverage-bcbs-example (Coverage)](Coverage-coverage-bcbs-example.md)
* [coverage-upmc-example (Coverage)](Coverage-coverage-upmc-example.md)
* [device-example (Device)](Device-device-example.md)
* [diagnosticreport-lab-example (DiagnosticReport)](DiagnosticReport-diagnosticreport-lab-example.md)
* [diagnosticreport-note-example (DiagnosticReport)](DiagnosticReport-diagnosticreport-note-example.md)
* [documentreference-example (DocumentReference)](DocumentReference-documentreference-example.md)
* [encounter-ambulatory (Encounter)](Encounter-encounter-ambulatory.md)
* [HealthCareSenderAndReceiver (Endpoint)](Endpoint-endpoint-healthcare-example.md)
* [PHAReceiver (Endpoint)](Endpoint-endpoint-pha-example.md)
* [goal-example (Goal)](Goal-goal-example.md)
* [immunization-example (Immunization)](Immunization-immunization-example.md)
* [General Hospital - Main Campus (Location)](Location-location-example.md)
* [medicationadministration-example (MedicationAdministration)](MedicationAdministration-medicationadministration-example.md)
* [medicationadministrationone-example (MedicationAdministration)](MedicationAdministration-medicationadministrationone-example.md)
* [MedicationRequest-example (MedicationRequest)](MedicationRequest-MedicationRequest-example.md)
* [messageheader-example-reportheader (MessageHeader)](MessageHeader-messageheader-example-reportheader.md)
* [observation-bp-example (Observation)](Observation-observation-bp-example.md)
* [observation-clinical-example (Observation)](Observation-observation-clinical-example.md)
* [observation-clinical-result-example (Observation)](Observation-observation-clinical-result-example.md)
* [observation-clinical-result-xray-example (Observation)](Observation-observation-clinical-result-xray-example.md)
* [observation-heartrate-example (Observation)](Observation-observation-heartrate-example.md)
* [observation-height-example (Observation)](Observation-observation-height-example.md)
* [observation-lab-example (Observation)](Observation-observation-lab-example.md)
* [observation-occupation-example (Observation)](Observation-observation-occupation-example.md)
* [observation-oximetry-example (Observation)](Observation-observation-oximetry-example.md)
* [observation-pregnancy-intent-example (Observation)](Observation-observation-pregnancy-intent-example.md)
* [observation-pregnancy-status-example (Observation)](Observation-observation-pregnancy-status-example.md)
* [observation-resprate-example (Observation)](Observation-observation-resprate-example.md)
* [observation-screening-assessment-example (Observation)](Observation-observation-screening-assessment-example.md)
* [observation-screening-example (Observation)](Observation-observation-screening-example.md)
* [observation-smoking-example (Observation)](Observation-observation-smoking-example.md)
* [observation-temperature-example (Observation)](Observation-observation-temperature-example.md)
* [observation-weight-example (Observation)](Observation-observation-weight-example.md)
* [General Hospital (Organization)](Organization-organization-example.md)
* [Example Healthcare Organization (Organization)](Organization-organization-healthcare.md)
* [Blue Cross Blue Shield (Organization)](Organization-organization-payer-bcbs.md)
* [UPMC Health Plan (Organization)](Organization-organization-payer-upmc.md)
* [Example PHA Organization (Organization)](Organization-organization-pha.md)
* [patient-baxter (Patient)](Patient-patient-baxter.md)
* [patient-ledner (Patient)](Patient-patient-ledner.md)
* [PlanDefinition National Health Care Surveys Example (PlanDefinition)](PlanDefinition-hcs-plandefinition-example.md)
* [practitioner-nichols (Practitioner)](Practitioner-practitioner-nichols.md)
* [procedure-example (Procedure)](Procedure-procedure-example.md)
* [example (ServiceRequest)](ServiceRequest-example.md)
* [servicerequest-example (ServiceRequest)](ServiceRequest-servicerequest-example.md)
