# Downloads - Health Care Surveys Reporting v2.0.0

## Downloads

### Full Implementation Guide

The entire implementation guide (including the HTML files, definitions, validation information, etc.) may be downloaded [here](../full-ig.zip).

### Package File

The following package file includes an NPM package file used by many of the FHIR tools. It contains all the value sets, profiles, extensions, list of pages and urls in the IG, etc defined as part of this version of the Implementation Guides. This file should be the first choice whenever generating any implementation artifacts since it contains all of the rules about what makes the profiles valid. Implementers will still need to be familiar with the content of the specification and profiles that apply in order to make a conformant implementation. See the overview on [validating FHIR profiles and resources](http://hl7.org/fhir/R4/validation.html):

* [Package](../package.tgz)

### Format Specific Definition Files

* [XML](../definitions.xml.zip)
* [JSON](../definitions.json.zip)
* [TTL](../definitions.ttl.zip)

### Examples: all the examples that are used in this Implementation Guide available for download:

* [XML](../examples.xml.zip)
* [JSON](../examples.json.zip)
* [TTl](../examples.ttl.zip)

### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.us.health-care-surveys-reporting.r4)](../package.r4.tgz) and [R4B (hl7.fhir.us.health-care-surveys-reporting.r4b)](../package.r4b.tgz) are available.

### Dependency Table










### Global Profiles Table

*There are no Global profiles defined*

### IP Statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/5.5.0/CodeSystem-ISO3166Part1.html): [HealthCareSurveysComposition](StructureDefinition-hcs-composition.md), [HealthCareSurveysMedicationAdministration](StructureDefinition-hcs-medicationadministration.md)... Show 6 more, [HealthCareSurveysPlanDefinition](StructureDefinition-hcs-plandefinition.md), [HealthcareSurveysContentBundle](StructureDefinition-hcs-content-bundle.md), [HealthcareSurveysReporting](index.md), [HealthcareSurveysReportingBundle](StructureDefinition-hcs-reporting-bundle.md), [HealthcareSurveysReportingEHRCapabilityStatement](CapabilityStatement-health-care-surveys-reporting-data-source.md) and [PlanDefinitionNationalHealthCareSurveysExample](PlanDefinition-hcs-plandefinition-example.md)


* Most of the information on the CDC and ATSDR websites is not subject to copyright, is in the public domain, and may be freely used or reproduced without obtaining copyright permission. For information and exceptions regarding use of CDC material please see [[https://www.cdc.gov/other/agencymaterials.html](https://www.cdc.gov/other/agencymaterials.html)](https://www.cdc.gov/other/agencymaterials.html) 

* [Vaccine Administered Code Set (CVX)](http://terminology.hl7.org/5.5.0/CodeSystem-CVX.html): [Immunization/immunization-example](Immunization-immunization-example.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/5.5.0/CodeSystem-v3-ucum.html): [MedicationAdministration/medicationadministration-example](MedicationAdministration-medicationadministration-example.md), [Observation/observation-bp-example](Observation-observation-bp-example.md)... Show 9 more, [Observation/observation-clinical-example](Observation-observation-clinical-example.md), [Observation/observation-clinical-result-example](Observation-observation-clinical-result-example.md), [Observation/observation-heartrate-example](Observation-observation-heartrate-example.md), [Observation/observation-height-example](Observation-observation-height-example.md), [Observation/observation-lab-example](Observation-observation-lab-example.md), [Observation/observation-oximetry-example](Observation-observation-oximetry-example.md), [Observation/observation-resprate-example](Observation-observation-resprate-example.md), [Observation/observation-temperature-example](Observation-observation-temperature-example.md) and [Observation/observation-weight-example](Observation-observation-weight-example.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/5.5.0/CodeSystem-v3-loinc.html): [Bundle/hcs-content-bundle-example](Bundle-hcs-content-bundle-example.md), [Bundle/healthcare-surveys-reporting-bundle](Bundle-healthcare-surveys-reporting-bundle.md)... Show 24 more, [Composition/hcs-composition-example](Composition-hcs-composition-example.md), [DiagnosticReport/diagnosticreport-lab-example](DiagnosticReport-diagnosticreport-lab-example.md), [DiagnosticReport/diagnosticreport-note-example](DiagnosticReport-diagnosticreport-note-example.md), [DocumentReference/documentreference-example](DocumentReference-documentreference-example.md), [HealthCareSurveysComposition](StructureDefinition-hcs-composition.md), [Observation/observation-bp-example](Observation-observation-bp-example.md), [Observation/observation-clinical-example](Observation-observation-clinical-example.md), [Observation/observation-clinical-result-example](Observation-observation-clinical-result-example.md), [Observation/observation-clinical-result-xray-example](Observation-observation-clinical-result-xray-example.md), [Observation/observation-heartrate-example](Observation-observation-heartrate-example.md), [Observation/observation-height-example](Observation-observation-height-example.md), [Observation/observation-lab-example](Observation-observation-lab-example.md), [Observation/observation-occupation-example](Observation-observation-occupation-example.md), [Observation/observation-oximetry-example](Observation-observation-oximetry-example.md), [Observation/observation-pregnancy-intent-example](Observation-observation-pregnancy-intent-example.md), [Observation/observation-pregnancy-status-example](Observation-observation-pregnancy-status-example.md), [Observation/observation-resprate-example](Observation-observation-resprate-example.md), [Observation/observation-screening-assessment-example](Observation-observation-screening-assessment-example.md), [Observation/observation-screening-example](Observation-observation-screening-example.md), [Observation/observation-smoking-example](Observation-observation-smoking-example.md), [Observation/observation-temperature-example](Observation-observation-temperature-example.md), [Observation/observation-weight-example](Observation-observation-weight-example.md), [ServiceRequest/example](ServiceRequest-example.md) and [ServiceRequest/servicerequest-example](ServiceRequest-servicerequest-example.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://tx.fhir.org/r4/ValueSet/snomedct): [AllergyIntolerance/allergyintolerance-sulfonamide-example](AllergyIntolerance-allergyintolerance-sulfonamide-example.md), [Condition/condition-encounter-diagnosis-example](Condition-condition-encounter-diagnosis-example.md)... Show 16 more, [Condition/condition-problem-liveborn-example](Condition-condition-problem-liveborn-example.md), [Condition/condition-problem-pharyngitis-example](Condition-condition-problem-pharyngitis-example.md), [Device/device-example](Device-device-example.md), [Encounter/encounter-ambulatory](Encounter-encounter-ambulatory.md), [Goal/goal-example](Goal-goal-example.md), [Immunization/immunization-example](Immunization-immunization-example.md), [MedicationAdministration/medicationadministration-example](MedicationAdministration-medicationadministration-example.md), [MedicationAdministration/medicationadministrationone-example](MedicationAdministration-medicationadministrationone-example.md), [MedicationRequest/MedicationRequest-example](MedicationRequest-MedicationRequest-example.md), [Observation/observation-pregnancy-status-example](Observation-observation-pregnancy-status-example.md), [Observation/observation-smoking-example](Observation-observation-smoking-example.md), [Patient/patient-ledner](Patient-patient-ledner.md), [Procedure/procedure-example](Procedure-procedure-example.md), [Respiratory Care Team](CareTeam-careteam-example.md), [ServiceRequest/example](ServiceRequest-example.md) and [ServiceRequest/servicerequest-example](ServiceRequest-servicerequest-example.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/allergyintolerance-sulfonamide-example](AllergyIntolerance-allergyintolerance-sulfonamide-example.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/allergyintolerance-sulfonamide-example](AllergyIntolerance-allergyintolerance-sulfonamide-example.md)
* [Condition Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-category.html): [Condition/condition-encounter-diagnosis-example](Condition-condition-encounter-diagnosis-example.md), [Condition/condition-problem-liveborn-example](Condition-condition-problem-liveborn-example.md) and [Condition/condition-problem-pharyngitis-example](Condition-condition-problem-pharyngitis-example.md)
* [Condition Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-condition-clinical.html): [Condition/condition-encounter-diagnosis-example](Condition-condition-encounter-diagnosis-example.md), [Condition/condition-problem-liveborn-example](Condition-condition-problem-liveborn-example.md) and [Condition/condition-problem-pharyngitis-example](Condition-condition-problem-pharyngitis-example.md)
* [ConditionVerificationStatus](http://terminology.hl7.org/7.0.1/CodeSystem-condition-ver-status.html): [Condition/condition-encounter-diagnosis-example](Condition-condition-encounter-diagnosis-example.md), [Condition/condition-problem-liveborn-example](Condition-condition-problem-liveborn-example.md) and [Condition/condition-problem-pharyngitis-example](Condition-condition-problem-pharyngitis-example.md)
* [Coverage Class Codes](http://terminology.hl7.org/7.0.1/CodeSystem-coverage-class.html): [Coverage/coverage-bcbs-example](Coverage-coverage-bcbs-example.md) and [Coverage/coverage-upmc-example](Coverage-coverage-upmc-example.md)
* [Endpoint Connection Type](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html): [Bundle/healthcare-surveys-reporting-bundle](Bundle-healthcare-surveys-reporting-bundle.md), [HealthCareSenderAndReceiver](Endpoint-endpoint-healthcare-example.md) and [PHAReceiver](Endpoint-endpoint-pha-example.md)
* [Goal achievement status](http://terminology.hl7.org/7.0.1/CodeSystem-goal-achievement.html): [Goal/goal-example](Goal-goal-example.md)
* [Location type](http://terminology.hl7.org/7.0.1/CodeSystem-location-physical-type.html): [General Hospital - Main Campus](Location-location-example.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Observation/observation-bp-example](Observation-observation-bp-example.md), [Observation/observation-clinical-example](Observation-observation-clinical-example.md)... Show 15 more, [Observation/observation-clinical-result-example](Observation-observation-clinical-result-example.md), [Observation/observation-clinical-result-xray-example](Observation-observation-clinical-result-xray-example.md), [Observation/observation-heartrate-example](Observation-observation-heartrate-example.md), [Observation/observation-height-example](Observation-observation-height-example.md), [Observation/observation-lab-example](Observation-observation-lab-example.md), [Observation/observation-occupation-example](Observation-observation-occupation-example.md), [Observation/observation-oximetry-example](Observation-observation-oximetry-example.md), [Observation/observation-pregnancy-intent-example](Observation-observation-pregnancy-intent-example.md), [Observation/observation-pregnancy-status-example](Observation-observation-pregnancy-status-example.md), [Observation/observation-resprate-example](Observation-observation-resprate-example.md), [Observation/observation-screening-assessment-example](Observation-observation-screening-assessment-example.md), [Observation/observation-screening-example](Observation-observation-screening-example.md), [Observation/observation-smoking-example](Observation-observation-smoking-example.md), [Observation/observation-temperature-example](Observation-observation-temperature-example.md) and [Observation/observation-weight-example](Observation-observation-weight-example.md)
* [Organization type](http://terminology.hl7.org/7.0.1/CodeSystem-organization-type.html): [Blue Cross Blue Shield](Organization-organization-payer-bcbs.md)
* [PlanDefinitionType](http://terminology.hl7.org/7.0.1/CodeSystem-plan-definition-type.html): [HealthCareSurveysPlanDefinition](StructureDefinition-hcs-plandefinition.md) and [PlanDefinitionNationalHealthCareSurveysExample](PlanDefinition-hcs-plandefinition-example.md)
* [SubscriberPolicyholder Relationship Codes](http://terminology.hl7.org/7.0.1/CodeSystem-subscriber-relationship.html): [Coverage/coverage-bcbs-example](Coverage-coverage-bcbs-example.md) and [Coverage/coverage-upmc-example](Coverage-coverage-upmc-example.md)
* [diagnosticServiceSectionId](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0074.html): [DiagnosticReport/diagnosticreport-lab-example](DiagnosticReport-diagnosticreport-lab-example.md)
* [identifierType](http://terminology.hl7.org/7.0.1/CodeSystem-v2-0203.html): [Coverage/coverage-upmc-example](Coverage-coverage-upmc-example.md) and [Patient/patient-baxter](Patient-patient-baxter.md)
* [ActCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ActCode.html): [Encounter/encounter-ambulatory](Encounter-encounter-ambulatory.md)
* [MaritalStatus](http://terminology.hl7.org/7.0.1/CodeSystem-v3-MaritalStatus.html): [Patient/patient-ledner](Patient-patient-ledner.md)
* [ObservationInterpretation](http://terminology.hl7.org/7.0.1/CodeSystem-v3-ObservationInterpretation.html): [Observation/observation-clinical-example](Observation-observation-clinical-example.md), [Observation/observation-clinical-result-example](Observation-observation-clinical-result-example.md), [Observation/observation-lab-example](Observation-observation-lab-example.md), [Observation/observation-screening-assessment-example](Observation-observation-screening-assessment-example.md) and [Observation/observation-screening-example](Observation-observation-screening-example.md)
* [RoleCode](http://terminology.hl7.org/7.0.1/CodeSystem-v3-RoleCode.html): [General Hospital - Main Campus](Location-location-example.md)
* [TribalEntityUS](http://terminology.hl7.org/7.0.1/CodeSystem-v3-TribalEntityUS.html): [Patient/patient-baxter](Patient-patient-baxter.md)


* Used by permission of HL7 International, all rights reserved Creative Commons License

* [US Core DocumentReferences Category Codes](http://hl7.org/fhir/us/core/STU6.1/CodeSystem-us-core-documentreference-category.html): [DocumentReference/documentreference-example](DocumentReference-documentreference-example.md)


* Using RxNorm codes of type SAB=RXNORM as this specification describes does not require a UMLS license. Access to the full set of RxNorm definitions, and/or additional use of other RxNorm structures and information requires a UMLS license. The use of RxNorm in this specification is pursuant to HL7's status as a licensee of the NLM UMLS. HL7's license does not convey the right to use RxNorm to any users of this specification; implementers must acquire a license to use RxNorm in their own right.

* [RxNorm](http://terminology.hl7.org/5.5.0/CodeSystem-v3-rxNorm.html): [MedicationAdministration/medicationadministration-example](MedicationAdministration-medicationadministration-example.md) and [MedicationAdministration/medicationadministrationone-example](MedicationAdministration-medicationadministrationone-example.md)


### Expansion Parameters

* Parameter: profile-url
  * Value: dc8fd4bd-091a-424a-8a3b-6198ef136891
* Parameter: system-version
  * Value: SNOMED CT[US]

