# Health Care Surveys PlanDefinition - Health Care Surveys Reporting v2.0.0

## Resource Profile: Health Care Surveys PlanDefinition 

 
This PlanDefinition profile defines the logic and rules around determining whether or not data from an encounter is reportable to National Center for Health Statistics (NCHS). 

**Usages:**

* Examples for this Profile: [PlanDefinitionNationalHealthCareSurveysExample](PlanDefinition-hcs-plandefinition-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.health-care-surveys-reporting|current/StructureDefinition/hcs-plandefinition)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-hcs-plandefinition.csv), [Excel](../StructureDefinition-hcs-plandefinition.xlsx), [Schematron](../StructureDefinition-hcs-plandefinition.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hcs-plandefinition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-plandefinition",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.59.42.6"
    }
  ],
  "version" : "2.0.0",
  "name" : "HealthCareSurveysPlanDefinition",
  "title" : "Health Care Surveys PlanDefinition",
  "status" : "active",
  "date" : "2026-01-21T01:15:19+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This PlanDefinition profile defines the logic and rules around determining whether or not data from an encounter is reportable to National Center for Health Statistics (NCHS).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PlanDefinition",
  "baseDefinition" : "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-plandefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PlanDefinition",
        "path" : "PlanDefinition",
        "short" : "Health Care Surveys Knowledge Artifact",
        "definition" : "This PlanDefinition profile defines the logic and rules around determining whether or not data from an encounter is reportable to National Center for Health Statistics (NCHS)."
      },
      {
        "id" : "PlanDefinition.action",
        "path" : "PlanDefinition.action",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "id"
            }
          ],
          "ordered" : true,
          "rules" : "open"
        },
        "min" : 5
      },
      {
        "id" : "PlanDefinition.action.code",
        "path" : "PlanDefinition.action.code",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/us/ph-library/ValueSet/us-ph-valueset-plandefinition-action"
        }
      },
      {
        "id" : "PlanDefinition.action:startWorkflow",
        "path" : "PlanDefinition.action",
        "sliceName" : "startWorkflow",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "patternString" : "start-workflow"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.description",
        "path" : "PlanDefinition.action.description",
        "patternString" : "Start the workflow action."
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.textEquivalent",
        "path" : "PlanDefinition.action.textEquivalent",
        "short" : "Text equivalent of the start workflow action.",
        "definition" : "Text equivalent of the start workflow action.",
        "min" : 1,
        "fixedString" : "Start the reporting workflow in response to an encounter-end event",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.code",
        "path" : "PlanDefinition.action.code",
        "short" : "Code for the start action.",
        "definition" : "The US-PH-PlanDefinition-Action code for the start action.",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "initiate-reporting-workflow"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.trigger",
        "path" : "PlanDefinition.action.trigger",
        "short" : "When the start action should be triggered.",
        "definition" : "When the start action should be triggered.",
        "min" : 1
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType",
        "short" : "Indicates the types of named events to subscribe to from the EHR."
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.trigger.name",
        "path" : "PlanDefinition.action.trigger.name",
        "definition" : "The name of the event, encounter-end in this case. For any action invoked as a result of this trigger, the triggering encounter is accessible via the context variable `%encounter`",
        "fixedString" : "encounter-end"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.relatedAction",
        "path" : "PlanDefinition.action.relatedAction",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.relatedAction.actionId",
        "path" : "PlanDefinition.action.relatedAction.actionId",
        "fixedId" : "check-reportability"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.relatedAction.relationship",
        "path" : "PlanDefinition.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:startWorkflow.relatedAction.offset[x]:offsetDuration",
        "path" : "PlanDefinition.action.relatedAction.offset[x]",
        "sliceName" : "offsetDuration",
        "type" : [
          {
            "code" : "Duration"
          }
        ],
        "example" : [
          {
            "label" : "Wait 72 hour before next action.",
            "valueDuration" : {
              "value" : 72,
              "unit" : "h"
            }
          }
        ]
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow",
        "path" : "PlanDefinition.action",
        "sliceName" : "executeReportingWorkflow",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "patternString" : "check-reportability"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.description",
        "path" : "PlanDefinition.action.description",
        "patternString" : "Execute reporting workflow action."
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.code",
        "path" : "PlanDefinition.action.code",
        "short" : "Code for the execute-reporting-workflow action.",
        "definition" : "The US-PH-PlanDefinition-Action code for the execute-reporting-workflow action.",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "execute-reporting-workflow"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action",
        "path" : "PlanDefinition.action.action",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "id"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "isAmbulatoryEncounterReportable",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "is-ambulatory-encounter-reportable",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "evaluate-condition"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.condition.kind",
        "path" : "PlanDefinition.action.action.condition.kind",
        "fixedCode" : "applicability"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.condition.expression",
        "path" : "PlanDefinition.action.action.condition.expression",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.condition.expression.language",
        "path" : "PlanDefinition.action.action.condition.expression.language",
        "fixedCode" : "text/fhirpath"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.input",
        "path" : "PlanDefinition.action.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.input.id",
        "path" : "PlanDefinition.action.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.relatedAction.actionId",
        "path" : "PlanDefinition.action.action.relatedAction.actionId",
        "fixedId" : "create-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isAmbulatoryEncounterReportable.relatedAction.relationship",
        "path" : "PlanDefinition.action.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable",
        "path" : "PlanDefinition.action.action",
        "sliceName" : "isInpatientEncounterReportable",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.id",
        "path" : "PlanDefinition.action.action.id",
        "min" : 1,
        "fixedString" : "is-inpatient-encounter-reportable",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.code",
        "path" : "PlanDefinition.action.action.code",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "evaluate-condition"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.condition.kind",
        "path" : "PlanDefinition.action.action.condition.kind",
        "fixedCode" : "applicability"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.condition.expression",
        "path" : "PlanDefinition.action.action.condition.expression",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.condition.expression.language",
        "path" : "PlanDefinition.action.action.condition.expression.language",
        "fixedCode" : "text/fhirpath"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.input",
        "path" : "PlanDefinition.action.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.input.id",
        "path" : "PlanDefinition.action.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.relatedAction.actionId",
        "path" : "PlanDefinition.action.action.relatedAction.actionId",
        "fixedId" : "create-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:executeReportingWorkflow.action:isInpatientEncounterReportable.relatedAction.relationship",
        "path" : "PlanDefinition.action.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:createReport",
        "path" : "PlanDefinition.action",
        "sliceName" : "createReport",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:createReport.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "patternString" : "create-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:createReport.description",
        "path" : "PlanDefinition.action.description",
        "patternString" : "Create HCS report action."
      },
      {
        "id" : "PlanDefinition.action:createReport.code",
        "path" : "PlanDefinition.action.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "create-report"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:createReport.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType"
      },
      {
        "id" : "PlanDefinition.action:createReport.input",
        "path" : "PlanDefinition.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement"
      },
      {
        "id" : "PlanDefinition.action:createReport.input.id",
        "path" : "PlanDefinition.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:createReport.output",
        "path" : "PlanDefinition.action.output",
        "definition" : "Defines output produced by the action. Required data is accessible via a context variable named `%[id]` using the `id` of the output data requirement"
      },
      {
        "id" : "PlanDefinition.action:createReport.output.id",
        "path" : "PlanDefinition.action.output.id",
        "definition" : "The id of the output produced, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:createReport.relatedAction.actionId",
        "path" : "PlanDefinition.action.relatedAction.actionId",
        "fixedId" : "validate-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:createReport.relatedAction.relationship",
        "path" : "PlanDefinition.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:validateReport",
        "path" : "PlanDefinition.action",
        "sliceName" : "validateReport",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:validateReport.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "patternString" : "validate-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:validateReport.description",
        "path" : "PlanDefinition.action.description",
        "patternString" : "Validate HCS report action."
      },
      {
        "id" : "PlanDefinition.action:validateReport.code",
        "path" : "PlanDefinition.action.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "validate-report"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:validateReport.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType"
      },
      {
        "id" : "PlanDefinition.action:validateReport.input",
        "path" : "PlanDefinition.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement"
      },
      {
        "id" : "PlanDefinition.action:validateReport.input.id",
        "path" : "PlanDefinition.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:validateReport.output",
        "path" : "PlanDefinition.action.output",
        "definition" : "Defines output produced by the action. Required data is accessible via a context variable named `%[id]` using the `id` of the output data requirement"
      },
      {
        "id" : "PlanDefinition.action:validateReport.output.id",
        "path" : "PlanDefinition.action.output.id",
        "definition" : "The id of the output produced, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:validateReport.relatedAction.actionId",
        "path" : "PlanDefinition.action.relatedAction.actionId",
        "fixedId" : "submit-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:validateReport.relatedAction.relationship",
        "path" : "PlanDefinition.action.relatedAction.relationship",
        "fixedCode" : "before-start"
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport",
        "path" : "PlanDefinition.action",
        "sliceName" : "submitHcsReport",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.id",
        "path" : "PlanDefinition.action.id",
        "min" : 1,
        "patternString" : "submit-hcs-report"
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.description",
        "path" : "PlanDefinition.action.description",
        "patternString" : "Submit HCS report action."
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.textEquivalent",
        "path" : "PlanDefinition.action.textEquivalent",
        "min" : 1,
        "fixedString" : "Route and send HCS Report",
        "mustSupport" : true
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.code",
        "path" : "PlanDefinition.action.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/us/ph-library/CodeSystem/us-ph-codesystem-plandefinition-actions",
              "code" : "submit-report"
            }
          ]
        }
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.trigger.extension:namedEventType",
        "path" : "PlanDefinition.action.trigger.extension",
        "sliceName" : "namedEventType"
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.input",
        "path" : "PlanDefinition.action.input",
        "definition" : "Defines input data requirements for the action. Required data is accessible via a context variable named `%[id]` using the `id` of the input data requirement"
      },
      {
        "id" : "PlanDefinition.action:submitHcsReport.input.id",
        "path" : "PlanDefinition.action.input.id",
        "definition" : "The id of the input requirement, allowing the data to be referenced via a context variable named `%[id]`",
        "min" : 1,
        "mustSupport" : true
      }
    ]
  }
}

```
