# Health Care Surveys Medication Administration - Health Care Surveys Reporting v2.0.0

## Resource Profile: Health Care Surveys Medication Administration 

 
This is the MedicationAdmininstration Resource profile for the IG. 

**Usages:**

* Refer to this Profile: [Health Care Surveys Composition](StructureDefinition-hcs-composition.md)
* Examples for this Profile: [MedicationAdministration/medicationadministration-example](MedicationAdministration-medicationadministration-example.md) and [MedicationAdministration/medicationadministrationone-example](MedicationAdministration-medicationadministrationone-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.us.health-care-surveys-reporting|current/StructureDefinition/hcs-medicationadministration)

### Formal Views of Profile Content

 [Description Differentials, Snapshots, and other representations](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](../StructureDefinition-hcs-medicationadministration.csv), [Excel](../StructureDefinition-hcs-medicationadministration.xlsx), [Schematron](../StructureDefinition-hcs-medicationadministration.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "hcs-medicationadministration",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-wg",
      "valueCode" : "pher"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 3,
      "_valueInteger" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use",
      "_valueCode" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-conformance-derivedFrom",
            "valueCanonical" : "http://hl7.org/fhir/us/health-care-surveys-reporting/ImplementationGuide/hl7.fhir.us.health-care-surveys-reporting"
          }
        ]
      }
    }
  ],
  "url" : "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-medicationadministration",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.4.642.40.59.42.4"
    }
  ],
  "version" : "2.0.0",
  "name" : "HealthCareSurveysMedicationAdministration",
  "title" : "Health Care Surveys Medication Administration",
  "status" : "active",
  "date" : "2026-01-21T01:15:19+00:00",
  "publisher" : "HL7 International / Public Health",
  "contact" : [
    {
      "name" : "HL7 International / Public Health",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org/Special/committees/pher"
        },
        {
          "system" : "email",
          "value" : "ord@lists.HL7.org"
        }
      ]
    }
  ],
  "description" : "This is the MedicationAdmininstration Resource profile for the IG.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "US"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationAdministration",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationAdministration",
        "path" : "MedicationAdministration",
        "short" : "HCS Medication Administration",
        "definition" : "Sets expectations for supported capabilities for MedicationAdmininstration resource",
        "mustSupport" : false
      },
      {
        "id" : "MedicationAdministration.statusReason",
        "path" : "MedicationAdministration.statusReason",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.medication[x]",
        "path" : "MedicationAdministration.medication[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.subject",
        "path" : "MedicationAdministration.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-patient|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.context",
        "path" : "MedicationAdministration.context",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/us/core/StructureDefinition/us-core-encounter|6.1.0"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.effective[x]",
        "path" : "MedicationAdministration.effective[x]",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.performer",
        "path" : "MedicationAdministration.performer",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.reasonCode",
        "path" : "MedicationAdministration.reasonCode",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.reasonReference",
        "path" : "MedicationAdministration.reasonReference",
        "mustSupport" : true
      },
      {
        "id" : "MedicationAdministration.dosage",
        "path" : "MedicationAdministration.dosage",
        "mustSupport" : true
      }
    ]
  }
}

```
