# ServiceRequest - CT Chest Evaluation - Health Care Surveys Reporting v2.0.0

## Example ServiceRequest: ServiceRequest - CT Chest Evaluation

Language: en

Profile: [US Core ServiceRequest Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-servicerequest.html)

**status**: Active

**intent**: Order

**category**: Evaluation procedure (procedure)

**priority**: Routine

**code**: CT Chest

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md)

**occurrence**: 2025-01-03 10:00:00+0000

**authoredOn**: 2025-01-02

**requester**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**reasonCode**: Acute viral pharyngitis



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "servicerequest-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-servicerequest|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "386053000",
          "display" : "Evaluation procedure (procedure)"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "24627-2",
        "display" : "CT Chest"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "occurrenceDateTime" : "2025-01-03T10:00:00Z",
  "authoredOn" : "2025-01-02",
  "requester" : {
    "reference" : "Practitioner/practitioner-nichols"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "195662009",
          "display" : "Acute viral pharyngitis"
        }
      ]
    }
  ]
}

```
