# Organization - General Hospital - Health Care Surveys Reporting v2.0.0

## Example Organization: Organization - General Hospital

Language: en

Profile: [US Core Organization Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-organization.html)

**identifier**: [United States National Provider Identifier](http://terminology.hl7.org/5.5.0/NamingSystem-npi.html)/1234567893

**active**: true

**name**: General Hospital

**telecom**: ph: 555-555-5555(Work), [contact@generalhospital.example.com](mailto:contact@generalhospital.example.com)

**address**: 123 Main St Anytown CA 12345 US 



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "organization-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-organization|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://hl7.org/fhir/sid/us-npi",
      "value" : "1234567893"
    }
  ],
  "active" : true,
  "name" : "General Hospital",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "work"
    },
    {
      "system" : "email",
      "value" : "contact@generalhospital.example.com",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "line" : ["123 Main St"],
      "city" : "Anytown",
      "state" : "CA",
      "postalCode" : "12345",
      "country" : "US"
    }
  ]
}

```
