# Observation - Smoking Status - Health Care Surveys Reporting v2.0.0

## Example Observation: Observation - Smoking Status

Language: en

Profile: [US Core Smoking Status Observation Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-smokingstatus.html)

**status**: Final

**category**: Social History

**code**: Tobacco smoking status

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Ambulatory Office Visit](Encounter-encounter-ambulatory.md)

**effective**: 2025-01-02

**performer**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**value**: Never smoked tobacco



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-smoking-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-smokingstatus|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "social-history"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "72166-2",
        "display" : "Tobacco smoking status"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory",
    "display" : "Ambulatory Office Visit"
  },
  "effectiveDateTime" : "2025-01-02",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "266919005",
        "display" : "Never smoked tobacco"
      }
    ]
  }
}

```
