# Observation - Chest X-ray Clinical Result - Health Care Surveys Reporting v2.0.0

## Example Observation: Observation - Chest X-ray Clinical Result

Language: en

Profile: [US Core Observation Clinical Result Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-clinical-result.html)

**status**: Final

**category**: Imaging

**code**: Radiology Study observation (narrative)

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Ambulatory Office Visit](Encounter-encounter-ambulatory.md)

**effective**: 2025-01-02

**issued**: 2025-01-02 10:30:00+0000

**performer**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**value**: LINES AND TUBES: None. LUNGS AND PLEURA: Clear lungs. Normal pulmonary vascularity. No pleural effusion. No pneumothorax. HEART, MEDIASTINUM AND HILA: Heart is normal in size. Normal mediastinal and hilar contour. BONES AND SOFT TISSUES: No acute abnormality.



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-clinical-result-xray-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging",
          "display" : "Imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18782-3",
        "display" : "Radiology Study observation (narrative)"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory",
    "display" : "Ambulatory Office Visit"
  },
  "effectiveDateTime" : "2025-01-02",
  "issued" : "2025-01-02T10:30:00Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "valueString" : "LINES AND TUBES: None.\n LUNGS AND PLEURA:\n Clear lungs. Normal pulmonary vascularity.\n No pleural effusion.\n No pneumothorax.\n HEART, MEDIASTINUM AND HILA:\n Heart is normal in size.\n Normal mediastinal and hilar contour.\n BONES AND SOFT TISSUES:\n No acute abnormality."
}

```
