# Observation - Body Temperature (Clinical Result) - Health Care Surveys Reporting v2.0.0

## Example Observation: Observation - Body Temperature (Clinical Result)

Language: en

Profile: [US Core Observation Clinical Result Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-observation-clinical-result.html)

**status**: Final

**category**: Vital Signs

**code**: Body temperature

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md)

**effective**: 2025-01-02 09:30:00+0000

**issued**: 2025-01-02 09:35:00+0000

**performer**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**value**: 37.8 C (Details: UCUM codeCel = 'Cel')

**interpretation**: High



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "observation-clinical-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-observation-clinical-result|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "8310-5",
        "display" : "Body temperature"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "effectiveDateTime" : "2025-01-02T09:30:00Z",
  "issued" : "2025-01-02T09:35:00Z",
  "performer" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "valueQuantity" : {
    "value" : 37.8,
    "unit" : "C",
    "system" : "http://unitsofmeasure.org",
    "code" : "Cel"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ObservationInterpretation",
          "code" : "H",
          "display" : "High"
        }
      ]
    }
  ]
}

```
