# MedicationRequest - Amoxicillin (Entered in Error) - Health Care Surveys Reporting v2.0.0

## Example MedicationRequest: MedicationRequest - Amoxicillin (Entered in Error)

Language: en

Profile: [US Core MedicationRequest Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-medicationrequest.html)

**status**: Entered in Error

**intent**: Order

**medication**: Amoxicillin-containing product

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**encounter**: [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md)

**authoredOn**: 2025-11-01

**requester**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**note**: 

> 

Patient indicated that they thought it was Amoxicillin they were taking but it was really Erythromycin




## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "MedicationRequest-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-medicationrequest|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "entered-in-error",
  "intent" : "order",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "27658006",
        "display" : "Amoxicillin-containing product"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "encounter" : {
    "reference" : "Encounter/encounter-ambulatory"
  },
  "authoredOn" : "2025-11-01",
  "requester" : {
    "reference" : "Practitioner/practitioner-nichols"
  },
  "note" : [
    {
      "text" : "Patient indicated that they thought it was Amoxicillin they were taking but it was really Erythromycin"
    }
  ]
}

```
