# MedicationAdministration - Lantus Insulin - Health Care Surveys Reporting v2.0.0

## Example MedicationAdministration: MedicationAdministration - Lantus Insulin

Language: en

Profile: [Health Care Surveys Medication Administration](StructureDefinition-hcs-medicationadministration.md)

**status**: Completed

**medication**: Lantus 100 UNT/ML Injectable Solution

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**effective**: 2025-01-02 09:00:00+0000

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md) |

**reasonCode**: Shivering

### Dosages

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Text** | **Route** | **Dose** |
| * | 400 mg orally | Oral route | 400 mg |



## Resource Content

```json
{
  "resourceType" : "MedicationAdministration",
  "id" : "medicationadministrationone-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/health-care-surveys-reporting/StructureDefinition/hcs-medicationadministration"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "285018",
        "display" : "Lantus 100 UNT/ML Injectable Solution"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "effectiveDateTime" : "2025-01-02T09:00:00Z",
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/practitioner-nichols"
      }
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "43724002",
          "display" : "Shivering"
        }
      ]
    }
  ],
  "dosage" : {
    "text" : "400 mg orally",
    "route" : {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "code" : "26643006",
          "display" : "Oral route"
        }
      ]
    },
    "dose" : {
      "value" : 400,
      "unit" : "mg"
    }
  }
}

```
