# Location - General Hospital Main Campus - Health Care Surveys Reporting v2.0.0

## Example Location: Location - General Hospital Main Campus

Language: en

Profile: [US Core Location Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-location.html)

**identifier**: `http://www.acme.org/location`/29

**status**: Active

**name**: General Hospital - Main Campus

**description**: Main Hospital Campus

**mode**: Instance

**type**: Hospital

**telecom**: ph: 555-555-5555(Work)

**address**: 123 Main St Anytown CA 12345 US 

**physicalType**: Building

**managingOrganization**: [Organization General Hospital](Organization-organization-example.md)



## Resource Content

```json
{
  "resourceType" : "Location",
  "id" : "location-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-location|6.1.0"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://www.acme.org/location",
      "value" : "29"
    }
  ],
  "status" : "active",
  "name" : "General Hospital - Main Campus",
  "description" : "Main Hospital Campus",
  "mode" : "instance",
  "type" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
          "code" : "HOSP",
          "display" : "Hospital"
        }
      ]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "555-555-5555",
      "use" : "work"
    }
  ],
  "address" : {
    "line" : ["123 Main St"],
    "city" : "Anytown",
    "state" : "CA",
    "postalCode" : "12345",
    "country" : "US"
  },
  "physicalType" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/location-physical-type",
        "code" : "bu",
        "display" : "Building"
      }
    ]
  },
  "managingOrganization" : {
    "reference" : "Organization/organization-example"
  }
}

```
