# Immunization - Influenza Vaccine - Health Care Surveys Reporting v2.0.0

## Example Immunization: Immunization - Influenza Vaccine

Language: en

Profile: [US Core Immunization Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-immunization.html)

**status**: Completed

**vaccineCode**: Influenza, split virus, quadrivalent, preservative

**patient**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**occurrence**: 2024-10-15

**primarySource**: true

**location**: [Location General Hospital - Main Campus](Location-location-example.md)

**manufacturer**: [Organization General Hospital](Organization-organization-example.md)

**lotNumber**: 123456A

**expirationDate**: 2025-06-30

**site**: Left upper arm structure

**route**: Intramuscular route

**doseQuantity**: 0.5 mL

### Performers

| | |
| :--- | :--- |
| - | **Actor** |
| * | [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md) |

**isSubpotent**: false

### Educations

| | | | |
| :--- | :--- | :--- | :--- |
| - | **DocumentType** | **PublicationDate** | **PresentationDate** |
| * | VIS | 2024-08-01 | 2024-10-15 |



## Resource Content

```json
{
  "resourceType" : "Immunization",
  "id" : "immunization-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-immunization|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "completed",
  "vaccineCode" : {
    "coding" : [
      {
        "system" : "http://hl7.org/fhir/sid/cvx",
        "code" : "158",
        "display" : "Influenza, split virus, quadrivalent, preservative"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/patient-ledner"
  },
  "occurrenceDateTime" : "2024-10-15",
  "primarySource" : true,
  "location" : {
    "reference" : "Location/location-example"
  },
  "manufacturer" : {
    "reference" : "Organization/organization-example"
  },
  "lotNumber" : "123456A",
  "expirationDate" : "2025-06-30",
  "site" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "368208006",
        "display" : "Left upper arm structure"
      }
    ]
  },
  "route" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "78421000",
        "display" : "Intramuscular route"
      }
    ]
  },
  "doseQuantity" : {
    "value" : 0.5,
    "unit" : "mL"
  },
  "performer" : [
    {
      "actor" : {
        "reference" : "Practitioner/practitioner-nichols"
      }
    }
  ],
  "isSubpotent" : false,
  "education" : [
    {
      "documentType" : "VIS",
      "publicationDate" : "2024-08-01",
      "presentationDate" : "2024-10-15"
    }
  ]
}

```
