# Endpoint - Healthcare Organization FHIR Server - Health Care Surveys Reporting v2.0.0

## Example Endpoint: Endpoint - Healthcare Organization FHIR Server

Language: en

Profile: [US Public Health Endpoint](http://hl7.org/fhir/us/ph-library/STU1/StructureDefinition-us-ph-endpoint.html)

**identifier**: `http://example.org/healthcare.org/enpoint-identifier`/endpoint-healthcare-example-id

**status**: Active

**connectionType**: [Endpoint Connection Type: hl7-fhir-rest](http://terminology.hl7.org/7.0.1/CodeSystem-endpoint-connection-type.html#endpoint-connection-type-hl7-fhir-rest) (HL7 FHIR)

**name**: HealthCareSenderAndReceiver

**managingOrganization**: [Organization Example Healthcare Organization](Organization-organization-healthcare.md)

**contact**: [endpointmanager@example.healthcare.org](mailto:endpointmanager@example.healthcare.org)

**period**: 2020-11-20 --> (ongoing)

**payloadType**: Bundle

**payloadMimeType**: application/fhir+xml, application/fhir+json

**address**: [http://example.org/healthcare.org/fhir](http://example.org/healthcare.org/fhir)



## Resource Content

```json
{
  "resourceType" : "Endpoint",
  "id" : "endpoint-healthcare-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/ph-library/StructureDefinition/us-ph-endpoint"
    ]
  },
  "language" : "en",
  "identifier" : [
    {
      "system" : "http://example.org/healthcare.org/enpoint-identifier",
      "value" : "endpoint-healthcare-example-id"
    }
  ],
  "status" : "active",
  "connectionType" : {
    "system" : "http://terminology.hl7.org/CodeSystem/endpoint-connection-type",
    "code" : "hl7-fhir-rest"
  },
  "name" : "HealthCareSenderAndReceiver",
  "managingOrganization" : {
    "reference" : "Organization/organization-healthcare"
  },
  "contact" : [
    {
      "system" : "email",
      "value" : "endpointmanager@example.healthcare.org",
      "use" : "work"
    }
  ],
  "period" : {
    "start" : "2020-11-20"
  },
  "payloadType" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/resource-types",
          "code" : "Bundle"
        }
      ]
    }
  ],
  "payloadMimeType" : ["application/fhir+xml", "application/fhir+json"],
  "address" : "http://example.org/healthcare.org/fhir"
}

```
