# DocumentReference - Consultation Note - Health Care Surveys Reporting v2.0.0

## Example DocumentReference: DocumentReference - Consultation Note

Language: en

Profile: [US Core DocumentReference Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-documentreference.html)

**status**: Current

**type**: Consult note

**category**: Clinical Note

**subject**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)

**date**: 2025-01-02 10:30:00+0000

**author**: [Practitioner Joseph P Nichols (official)](Practitioner-practitioner-nichols.md)

**custodian**: [Organization General Hospital](Organization-organization-example.md)

> **content**

### Attachments

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| - | **ContentType** | **Language** | **Data** | **Title** |
| * | text/plain | English (Region=United States) | `UGF0aWVudCBwcmVzZW50ZWQgd2l0aCBvbmUgd2VlayBoaXN0b3J5IG9mIGNvdWdoIGFuZCBsb3ctZ3JhZGUgZmV2ZXIuIEx1bmdzIGNsZWFyIG9uIGV4YW1pbmF0aW9uLiBObyBseW1waGFkZW5vcGF0aHkuIERpYWdub3NpczogeEFjdXRlIGJyb25jaGl0aXMuIA==` | Consultation Note |


### Contexts

| | | |
| :--- | :--- | :--- |
| - | **Encounter** | **Period** |
| * | [Encounter: status = finished; class = ambulatory (ActCode#AMB); type = Normal delivery procedure (procedure); period = 2025-11-01 17:00:14-0500 --> 2025-11-01 18:00:14-0500](Encounter-encounter-ambulatory.md) | 2025-01-02 09:00:00+0000 --> 2025-01-02 10:00:00+0000 |



## Resource Content

```json
{
  "resourceType" : "DocumentReference",
  "id" : "documentreference-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-documentreference|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "current",
  "type" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "11488-4",
        "display" : "Consult note"
      }
    ]
  },
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://hl7.org/fhir/us/core/CodeSystem/us-core-documentreference-category",
          "code" : "clinical-note",
          "display" : "Clinical Note"
        }
      ]
    }
  ],
  "subject" : {
    "reference" : "Patient/patient-ledner"
  },
  "date" : "2025-01-02T10:30:00Z",
  "author" : [
    {
      "reference" : "Practitioner/practitioner-nichols"
    }
  ],
  "custodian" : {
    "reference" : "Organization/organization-example"
  },
  "content" : [
    {
      "attachment" : {
        "contentType" : "text/plain",
        "language" : "en-US",
        "data" : "UGF0aWVudCBwcmVzZW50ZWQgd2l0aCBvbmUgd2VlayBoaXN0b3J5IG9mIGNvdWdoIGFuZCBsb3ctZ3JhZGUgZmV2ZXIuIEx1bmdzIGNsZWFyIG9uIGV4YW1pbmF0aW9uLiBObyBseW1waGFkZW5vcGF0aHkuIERpYWdub3NpczogeEFjdXRlIGJyb25jaGl0aXMuIA==",
        "title" : "Consultation Note"
      }
    }
  ],
  "context" : {
    "encounter" : [
      {
        "reference" : "Encounter/encounter-ambulatory"
      }
    ],
    "period" : {
      "start" : "2025-01-02T09:00:00Z",
      "end" : "2025-01-02T10:00:00Z"
    }
  }
}

```
