# Device - Cardiac Pacemaker - Health Care Surveys Reporting v2.0.0

## Example Device: Device - Cardiac Pacemaker

Language: en

Profile: [US Core Implantable Device Profileversion: null6.1.0)](http://hl7.org/fhir/us/core/STU6.1/StructureDefinition-us-core-implantable-device.html)

**status**: Active

**manufacturer**: Device Manufacturer Inc.

**manufactureDate**: 2023-01-15

**expirationDate**: 2028-01-15

**lotNumber**: LOT123456

**serialNumber**: SER987654

### DeviceNames

| | | |
| :--- | :--- | :--- |
| - | **Name** | **Type** |
| * | Pacemaker Model X1000 | User Friendly name |

**type**: Cardiac transvenous pacemaker

**patient**: [Dominique Ledner Female, DoB: 1965-06-22 ( MRN: Alaska Driver's License#abc123 (use: usual, ))](Patient-patient-ledner.md)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "device-example",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/us/core/StructureDefinition/us-core-implantable-device|6.1.0"
    ]
  },
  "language" : "en",
  "status" : "active",
  "manufacturer" : "Device Manufacturer Inc.",
  "manufactureDate" : "2023-01-15",
  "expirationDate" : "2028-01-15",
  "lotNumber" : "LOT123456",
  "serialNumber" : "SER987654",
  "deviceName" : [
    {
      "name" : "Pacemaker Model X1000",
      "type" : "user-friendly-name"
    }
  ],
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "56961003",
        "display" : "Cardiac transvenous pacemaker"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/patient-ledner"
  }
}

```
